package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Associate Audited Organization with the User operation
 */
@Generated(from = "_AssociateUserAuditedOrganizationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AssociateUserAuditedOrganizationRequest
    extends org.cloudfoundry.client.v2.users._AssociateUserAuditedOrganizationRequest {
  private final String auditedOrganizationId;
  private final String userId;

  private AssociateUserAuditedOrganizationRequest(AssociateUserAuditedOrganizationRequest.Builder builder) {
    this.auditedOrganizationId = builder.auditedOrganizationId;
    this.userId = builder.userId;
  }

  /**
   * The id of the audited organization
   */
  @Override
  public String getAuditedOrganizationId() {
    return auditedOrganizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateUserAuditedOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateUserAuditedOrganizationRequest
        && equalTo(0, (AssociateUserAuditedOrganizationRequest) another);
  }

  private boolean equalTo(int synthetic, AssociateUserAuditedOrganizationRequest another) {
    return auditedOrganizationId.equals(another.auditedOrganizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code auditedOrganizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + auditedOrganizationId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateUserAuditedOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateUserAuditedOrganizationRequest{"
        + "auditedOrganizationId=" + auditedOrganizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateUserAuditedOrganizationRequest AssociateUserAuditedOrganizationRequest}.
   * <pre>
   * AssociateUserAuditedOrganizationRequest.builder()
   *    .auditedOrganizationId(String) // required {@link AssociateUserAuditedOrganizationRequest#getAuditedOrganizationId() auditedOrganizationId}
   *    .userId(String) // required {@link AssociateUserAuditedOrganizationRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new AssociateUserAuditedOrganizationRequest builder
   */
  public static AssociateUserAuditedOrganizationRequest.Builder builder() {
    return new AssociateUserAuditedOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateUserAuditedOrganizationRequest AssociateUserAuditedOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AssociateUserAuditedOrganizationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUDITED_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String auditedOrganizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateUserAuditedOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateUserAuditedOrganizationRequest instance) {
      return from((_AssociateUserAuditedOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateUserAuditedOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateUserAuditedOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      auditedOrganizationId(instance.getAuditedOrganizationId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserAuditedOrganizationRequest#getAuditedOrganizationId() auditedOrganizationId} attribute.
     * @param auditedOrganizationId The value for auditedOrganizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationId(String auditedOrganizationId) {
      this.auditedOrganizationId = Objects.requireNonNull(auditedOrganizationId, "auditedOrganizationId");
      initBits &= ~INIT_BIT_AUDITED_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserAuditedOrganizationRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateUserAuditedOrganizationRequest AssociateUserAuditedOrganizationRequest}.
     * @return An immutable instance of AssociateUserAuditedOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateUserAuditedOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateUserAuditedOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUDITED_ORGANIZATION_ID) != 0) attributes.add("auditedOrganizationId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build AssociateUserAuditedOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
