package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Audited Spaces for the User operation
 */
@Generated(from = "_ListUserAuditedSpacesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListUserAuditedSpacesRequest
    extends org.cloudfoundry.client.v2.users._ListUserAuditedSpacesRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable String applicationId;
  private final @Nullable String developerId;
  private final @Nullable String name;
  private final @Nullable String organizationId;
  private final String userId;

  private ListUserAuditedSpacesRequest(ListUserAuditedSpacesRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.applicationId = builder.applicationId;
    this.developerId = builder.developerId;
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.userId = builder.userId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The application id
   */
  @Override
  public @Nullable String getApplicationId() {
    return applicationId;
  }

  /**
   * The developer id
   */
  @Override
  public @Nullable String getDeveloperId() {
    return developerId;
  }

  /**
   * The name
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code ListUserAuditedSpacesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListUserAuditedSpacesRequest
        && equalTo(0, (ListUserAuditedSpacesRequest) another);
  }

  private boolean equalTo(int synthetic, ListUserAuditedSpacesRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(applicationId, another.applicationId)
        && Objects.equals(developerId, another.developerId)
        && Objects.equals(name, another.name)
        && Objects.equals(organizationId, another.organizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code applicationId}, {@code developerId}, {@code name}, {@code organizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(applicationId);
    h += (h << 5) + Objects.hashCode(developerId);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListUserAuditedSpacesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListUserAuditedSpacesRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", applicationId=" + applicationId
        + ", developerId=" + developerId
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link ListUserAuditedSpacesRequest ListUserAuditedSpacesRequest}.
   * <pre>
   * ListUserAuditedSpacesRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListUserAuditedSpacesRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListUserAuditedSpacesRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListUserAuditedSpacesRequest#getResultsPerPage() resultsPerPage}
   *    .applicationId(String | null) // nullable {@link ListUserAuditedSpacesRequest#getApplicationId() applicationId}
   *    .developerId(String | null) // nullable {@link ListUserAuditedSpacesRequest#getDeveloperId() developerId}
   *    .name(String | null) // nullable {@link ListUserAuditedSpacesRequest#getName() name}
   *    .organizationId(String | null) // nullable {@link ListUserAuditedSpacesRequest#getOrganizationId() organizationId}
   *    .userId(String) // required {@link ListUserAuditedSpacesRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new ListUserAuditedSpacesRequest builder
   */
  public static ListUserAuditedSpacesRequest.Builder builder() {
    return new ListUserAuditedSpacesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListUserAuditedSpacesRequest ListUserAuditedSpacesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListUserAuditedSpacesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private long initBits = 0x1L;

    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private String applicationId;
    private String developerId;
    private String name;
    private String organizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListUserAuditedSpacesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListUserAuditedSpacesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListUserAuditedSpacesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListUserAuditedSpacesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.users._ListUserAuditedSpacesRequest) {
        org.cloudfoundry.client.v2.users._ListUserAuditedSpacesRequest instance = (org.cloudfoundry.client.v2.users._ListUserAuditedSpacesRequest) object;
        String organizationIdValue = instance.getOrganizationId();
        if (organizationIdValue != null) {
          organizationId(organizationIdValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String developerIdValue = instance.getDeveloperId();
        if (developerIdValue != null) {
          developerId(developerIdValue);
        }
        String applicationIdValue = instance.getApplicationId();
        if (applicationIdValue != null) {
          applicationId(applicationIdValue);
        }
        userId(instance.getUserId());
      }
    }

    /**
     * Initializes the value for the {@link ListUserAuditedSpacesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserAuditedSpacesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserAuditedSpacesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserAuditedSpacesRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserAuditedSpacesRequest#getDeveloperId() developerId} attribute.
     * @param developerId The value for developerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(@Nullable String developerId) {
      this.developerId = developerId;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserAuditedSpacesRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserAuditedSpacesRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserAuditedSpacesRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link ListUserAuditedSpacesRequest ListUserAuditedSpacesRequest}.
     * @return An immutable instance of ListUserAuditedSpacesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListUserAuditedSpacesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListUserAuditedSpacesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build ListUserAuditedSpacesRequest, some of required attributes are not set " + attributes;
    }
  }
}
