package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Managed Organization from the User operation
 */
@Generated(from = "_RemoveUserManagedOrganizationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveUserManagedOrganizationRequest
    extends org.cloudfoundry.client.v2.users._RemoveUserManagedOrganizationRequest {
  private final String managedOrganizationId;
  private final String userId;

  private RemoveUserManagedOrganizationRequest(RemoveUserManagedOrganizationRequest.Builder builder) {
    this.managedOrganizationId = builder.managedOrganizationId;
    this.userId = builder.userId;
  }

  /**
   * The id of the managed organization
   */
  @Override
  public String getManagedOrganizationId() {
    return managedOrganizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveUserManagedOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveUserManagedOrganizationRequest
        && equalTo(0, (RemoveUserManagedOrganizationRequest) another);
  }

  private boolean equalTo(int synthetic, RemoveUserManagedOrganizationRequest another) {
    return managedOrganizationId.equals(another.managedOrganizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code managedOrganizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + managedOrganizationId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveUserManagedOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveUserManagedOrganizationRequest{"
        + "managedOrganizationId=" + managedOrganizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveUserManagedOrganizationRequest RemoveUserManagedOrganizationRequest}.
   * <pre>
   * RemoveUserManagedOrganizationRequest.builder()
   *    .managedOrganizationId(String) // required {@link RemoveUserManagedOrganizationRequest#getManagedOrganizationId() managedOrganizationId}
   *    .userId(String) // required {@link RemoveUserManagedOrganizationRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new RemoveUserManagedOrganizationRequest builder
   */
  public static RemoveUserManagedOrganizationRequest.Builder builder() {
    return new RemoveUserManagedOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveUserManagedOrganizationRequest RemoveUserManagedOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveUserManagedOrganizationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MANAGED_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String managedOrganizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveUserManagedOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveUserManagedOrganizationRequest instance) {
      return from((_RemoveUserManagedOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveUserManagedOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveUserManagedOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      managedOrganizationId(instance.getManagedOrganizationId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserManagedOrganizationRequest#getManagedOrganizationId() managedOrganizationId} attribute.
     * @param managedOrganizationId The value for managedOrganizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationId(String managedOrganizationId) {
      this.managedOrganizationId = Objects.requireNonNull(managedOrganizationId, "managedOrganizationId");
      initBits &= ~INIT_BIT_MANAGED_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserManagedOrganizationRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveUserManagedOrganizationRequest RemoveUserManagedOrganizationRequest}.
     * @return An immutable instance of RemoveUserManagedOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveUserManagedOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveUserManagedOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANAGED_ORGANIZATION_ID) != 0) attributes.add("managedOrganizationId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build RemoveUserManagedOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
