package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Data type for the Buildpack
 */
@Generated(from = "_BuildpackData", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BuildpackData extends org.cloudfoundry.client.v3._BuildpackData {
  private final @Nullable List<String> buildpacks;
  private final @Nullable String stack;

  private BuildpackData(BuildpackData.Builder builder) {
    this.buildpacks = builder.buildpacks == null ? null : createUnmodifiableList(true, builder.buildpacks);
    this.stack = builder.stack;
  }

  /**
   * The buildpack
   */
  @JsonProperty("buildpacks")
  @Override
  public @Nullable List<String> getBuildpacks() {
    return buildpacks;
  }

  /**
   * The stack
   */
  @JsonProperty("stack")
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * This instance is equal to all instances of {@code BuildpackData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BuildpackData
        && equalTo(0, (BuildpackData) another);
  }

  private boolean equalTo(int synthetic, BuildpackData another) {
    return Objects.equals(buildpacks, another.buildpacks)
        && Objects.equals(stack, another.stack);
  }

  /**
   * Computes a hash code from attributes: {@code buildpacks}, {@code stack}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildpacks);
    h += (h << 5) + Objects.hashCode(stack);
    return h;
  }

  /**
   * Prints the immutable value {@code BuildpackData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BuildpackData{"
        + "buildpacks=" + buildpacks
        + ", stack=" + stack
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BuildpackData", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._BuildpackData {
    List<String> buildpacks = null;
    String stack;
    @JsonProperty("buildpacks")
    public void setBuildpacks(@Nullable List<String> buildpacks) {
      this.buildpacks = buildpacks;
    }
    @JsonProperty("stack")
    public void setStack(@Nullable String stack) {
      this.stack = stack;
    }
    @Override
    public List<String> getBuildpacks() { throw new UnsupportedOperationException(); }
    @Override
    public String getStack() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BuildpackData fromJson(Json json) {
    BuildpackData.Builder builder = BuildpackData.builder();
    if (json.buildpacks != null) {
      builder.addAllBuildpacks(json.buildpacks);
    }
    if (json.stack != null) {
      builder.stack(json.stack);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BuildpackData BuildpackData}.
   * <pre>
   * BuildpackData.builder()
   *    .buildpacks(List&amp;lt;String&amp;gt; | null) // nullable {@link BuildpackData#getBuildpacks() buildpacks}
   *    .stack(String | null) // nullable {@link BuildpackData#getStack() stack}
   *    .build();
   * </pre>
   * @return A new BuildpackData builder
   */
  public static BuildpackData.Builder builder() {
    return new BuildpackData.Builder();
  }

  /**
   * Builds instances of type {@link BuildpackData BuildpackData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BuildpackData", generator = "Immutables")
  public static final class Builder {
    private List<String> buildpacks = null;
    private String stack;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BuildpackData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BuildpackData instance) {
      return from((_BuildpackData) instance);
    }

    /**
     * Copy abstract value type {@code _BuildpackData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BuildpackData instance) {
      Objects.requireNonNull(instance, "instance");
      List<String> buildpacksValue = instance.getBuildpacks();
      if (buildpacksValue != null) {
        addAllBuildpacks(buildpacksValue);
      }
      String stackValue = instance.getStack();
      if (stackValue != null) {
        stack(stackValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link BuildpackData#getBuildpacks() buildpacks} list.
     * @param element A buildpacks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(String element) {
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      return this;
    }

    /**
     * Adds elements to {@link BuildpackData#getBuildpacks() buildpacks} list.
     * @param elements An array of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpacks(String... elements) {
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      for (String element : elements) {
        this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BuildpackData#getBuildpacks() buildpacks} list.
     * @param elements An iterable of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("buildpacks")
    public final Builder buildpacks(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.buildpacks = null;
        return this;
      }
      this.buildpacks = new ArrayList<String>();
      return addAllBuildpacks(elements);
    }

    /**
     * Adds elements to {@link BuildpackData#getBuildpacks() buildpacks} list.
     * @param elements An iterable of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBuildpacks(Iterable<String> elements) {
      Objects.requireNonNull(elements, "buildpacks element");
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      for (String element : elements) {
        this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BuildpackData#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stack")
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Builds a new {@link BuildpackData BuildpackData}.
     * @return An immutable instance of BuildpackData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BuildpackData build() {
      return new BuildpackData(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
