package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The metadata payload for a resource
 */
@Generated(from = "_Metadata", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Metadata extends org.cloudfoundry.client.v3._Metadata {
  private final @Nullable Map<String, String> annotations;
  private final @Nullable Map<String, String> labels;

  private Metadata(Metadata.Builder builder) {
    this.annotations = builder.annotations == null ? null : createUnmodifiableMap(false, false, builder.annotations);
    this.labels = builder.labels == null ? null : createUnmodifiableMap(false, false, builder.labels);
  }

  /**
   * The metadata annotations
   */
  @JsonInclude
  @JsonProperty("annotations")
  @Override
  public @Nullable Map<String, String> getAnnotations() {
    return annotations;
  }

  /**
   * The metadata labels
   */
  @JsonInclude
  @JsonProperty("labels")
  @Override
  public @Nullable Map<String, String> getLabels() {
    return labels;
  }

  /**
   * This instance is equal to all instances of {@code Metadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Metadata
        && equalTo(0, (Metadata) another);
  }

  private boolean equalTo(int synthetic, Metadata another) {
    return Objects.equals(annotations, another.annotations)
        && Objects.equals(labels, another.labels);
  }

  /**
   * Computes a hash code from attributes: {@code annotations}, {@code labels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(annotations);
    h += (h << 5) + Objects.hashCode(labels);
    return h;
  }

  /**
   * Prints the immutable value {@code Metadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Metadata{"
        + "annotations=" + annotations
        + ", labels=" + labels
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Metadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Metadata {
    Map<String, String> annotations = null;
    Map<String, String> labels = null;
    @JsonInclude
    @JsonProperty("annotations")
    public void setAnnotations(@Nullable Map<String, String> annotations) {
      this.annotations = annotations;
    }
    @JsonInclude
    @JsonProperty("labels")
    public void setLabels(@Nullable Map<String, String> labels) {
      this.labels = labels;
    }
    @Override
    public Map<String, String> getAnnotations() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getLabels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Metadata fromJson(Json json) {
    Metadata.Builder builder = Metadata.builder();
    if (json.annotations != null) {
      builder.putAllAnnotations(json.annotations);
    }
    if (json.labels != null) {
      builder.putAllLabels(json.labels);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Metadata Metadata}.
   * <pre>
   * Metadata.builder()
   *    .annotations(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link Metadata#getAnnotations() annotations}
   *    .labels(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link Metadata#getLabels() labels}
   *    .build();
   * </pre>
   * @return A new Metadata builder
   */
  public static Metadata.Builder builder() {
    return new Metadata.Builder();
  }

  /**
   * Builds instances of type {@link Metadata Metadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Metadata", generator = "Immutables")
  public static final class Builder {
    private Map<String, String> annotations = null;
    private Map<String, String> labels = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Metadata instance) {
      return from((_Metadata) instance);
    }

    /**
     * Copy abstract value type {@code _Metadata} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Metadata instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, String> annotationsValue = instance.getAnnotations();
      if (annotationsValue != null) {
        putAllAnnotations(annotationsValue);
      }
      Map<String, String> labelsValue = instance.getLabels();
      if (labelsValue != null) {
        putAllLabels(labelsValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link Metadata#getAnnotations() annotations} map.
     * @param key The key in the annotations map
     * @param value The associated value in the annotations map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder annotation(String key, String value) {
      if (this.annotations == null) {
        this.annotations = new LinkedHashMap<String, String>();
      }
      this.annotations.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Metadata#getAnnotations() annotations} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder annotation(Map.Entry<String, ? extends String> entry) {
      if (this.annotations == null) {
        this.annotations = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.annotations.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Metadata#getAnnotations() annotations} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the annotations map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonInclude
    @JsonProperty("annotations")
    public final Builder annotations(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.annotations = null;
        return this;
      }
      this.annotations = new LinkedHashMap<String, String>();
      return putAllAnnotations(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Metadata#getAnnotations() annotations} map. Nulls are not permitted
     * @param entries The entries that will be added to the annotations map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAnnotations(Map<String, ? extends String> entries) {
      if (this.annotations == null) {
        this.annotations = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.annotations.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link Metadata#getLabels() labels} map.
     * @param key The key in the labels map
     * @param value The associated value in the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(String key, String value) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      this.labels.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Metadata#getLabels() labels} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(Map.Entry<String, ? extends String> entry) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.labels.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Metadata#getLabels() labels} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonInclude
    @JsonProperty("labels")
    public final Builder labels(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.labels = null;
        return this;
      }
      this.labels = new LinkedHashMap<String, String>();
      return putAllLabels(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Metadata#getLabels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLabels(Map<String, ? extends String> entries) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.labels.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link Metadata Metadata}.
     * @return An immutable instance of Metadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Metadata build() {
      return new Metadata(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
