package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Application Feature operation.
 */
@Generated(from = "_GetApplicationFeatureRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetApplicationFeatureRequest
    extends org.cloudfoundry.client.v3.applications._GetApplicationFeatureRequest {
  private final String applicationId;
  private final String featureName;

  private GetApplicationFeatureRequest(GetApplicationFeatureRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.featureName = builder.featureName;
  }

  /**
   * The id of the application
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The required feature name
   */
  @Override
  public String getFeatureName() {
    return featureName;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationFeatureRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationFeatureRequest
        && equalTo(0, (GetApplicationFeatureRequest) another);
  }

  private boolean equalTo(int synthetic, GetApplicationFeatureRequest another) {
    return applicationId.equals(another.applicationId)
        && featureName.equals(another.featureName);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code featureName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + featureName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationFeatureRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationFeatureRequest{"
        + "applicationId=" + applicationId
        + ", featureName=" + featureName
        + "}";
  }

  /**
   * Creates a builder for {@link GetApplicationFeatureRequest GetApplicationFeatureRequest}.
   * <pre>
   * GetApplicationFeatureRequest.builder()
   *    .applicationId(String) // required {@link GetApplicationFeatureRequest#getApplicationId() applicationId}
   *    .featureName(String) // required {@link GetApplicationFeatureRequest#getFeatureName() featureName}
   *    .build();
   * </pre>
   * @return A new GetApplicationFeatureRequest builder
   */
  public static GetApplicationFeatureRequest.Builder builder() {
    return new GetApplicationFeatureRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationFeatureRequest GetApplicationFeatureRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetApplicationFeatureRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_FEATURE_NAME = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String featureName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationFeatureRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationFeatureRequest instance) {
      return from((_GetApplicationFeatureRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationFeatureRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationFeatureRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      featureName(instance.getFeatureName());
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationFeatureRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationFeatureRequest#getFeatureName() featureName} attribute.
     * @param featureName The value for featureName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder featureName(String featureName) {
      this.featureName = Objects.requireNonNull(featureName, "featureName");
      initBits &= ~INIT_BIT_FEATURE_NAME;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationFeatureRequest GetApplicationFeatureRequest}.
     * @return An immutable instance of GetApplicationFeatureRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationFeatureRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationFeatureRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_FEATURE_NAME) != 0) attributes.add("featureName");
      return "Cannot build GetApplicationFeatureRequest, some of required attributes are not set " + attributes;
    }
  }
}
