package org.cloudfoundry.client.v3.auditevents;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _AuditEventActor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code AuditEventActor.builder()}.
 */
@Generated(from = "_AuditEventActor", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AuditEventActor extends org.cloudfoundry.client.v3.auditevents._AuditEventActor {
  private final String id;
  private final String name;
  private final String type;

  private AuditEventActor(AuditEventActor.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.type = builder.type;
  }

  /**
   * The actor id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The actor name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The actor type
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code AuditEventActor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AuditEventActor
        && equalTo(0, (AuditEventActor) another);
  }

  private boolean equalTo(int synthetic, AuditEventActor another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AuditEventActor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuditEventActor{"
        + "id=" + id
        + ", name=" + name
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_AuditEventActor", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.auditevents._AuditEventActor {
    String id;
    String name;
    String type;
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static AuditEventActor fromJson(Json json) {
    AuditEventActor.Builder builder = AuditEventActor.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AuditEventActor AuditEventActor}.
   * <pre>
   * AuditEventActor.builder()
   *    .id(String) // required {@link AuditEventActor#getId() id}
   *    .name(String) // required {@link AuditEventActor#getName() name}
   *    .type(String) // required {@link AuditEventActor#getType() type}
   *    .build();
   * </pre>
   * @return A new AuditEventActor builder
   */
  public static AuditEventActor.Builder builder() {
    return new AuditEventActor.Builder();
  }

  /**
   * Builds instances of type {@link AuditEventActor AuditEventActor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AuditEventActor", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private String id;
    private String name;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuditEventActor} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuditEventActor instance) {
      return from((_AuditEventActor) instance);
    }

    /**
     * Copy abstract value type {@code _AuditEventActor} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AuditEventActor instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link AuditEventActor#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AuditEventActor#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AuditEventActor#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link AuditEventActor AuditEventActor}.
     * @return An immutable instance of AuditEventActor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AuditEventActor build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AuditEventActor(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build AuditEventActor, some of required attributes are not set " + attributes;
    }
  }
}
