package org.cloudfoundry.client.v3.auditevents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Audit Events operation
 */
@Generated(from = "_ListAuditEventsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListAuditEventsRequest
    extends org.cloudfoundry.client.v3.auditevents._ListAuditEventsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> organizationIds;
  private final List<String> spaceIds;
  private final List<String> targetIds;
  private final List<String> types;

  private ListAuditEventsRequest(ListAuditEventsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
    this.targetIds = createUnmodifiableList(true, builder.targetIds);
    this.types = createUnmodifiableList(true, builder.types);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The organization ids
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The request target ids
   */
  @Override
  public List<String> getTargetIds() {
    return targetIds;
  }

  /**
   * The types
   */
  @Override
  public List<String> getTypes() {
    return types;
  }

  /**
   * This instance is equal to all instances of {@code ListAuditEventsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListAuditEventsRequest
        && equalTo(0, (ListAuditEventsRequest) another);
  }

  private boolean equalTo(int synthetic, ListAuditEventsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && organizationIds.equals(another.organizationIds)
        && spaceIds.equals(another.spaceIds)
        && targetIds.equals(another.targetIds)
        && types.equals(another.types);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code organizationIds}, {@code spaceIds}, {@code targetIds}, {@code types}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    h += (h << 5) + targetIds.hashCode();
    h += (h << 5) + types.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListAuditEventsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListAuditEventsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", targetIds=" + targetIds
        + ", types=" + types
        + "}";
  }

  /**
   * Creates a builder for {@link ListAuditEventsRequest ListAuditEventsRequest}.
   * <pre>
   * ListAuditEventsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListAuditEventsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListAuditEventsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListAuditEventsRequest#getPerPage() perPage}
   *    .organizationId|addAllOrganizationIds(String) // {@link ListAuditEventsRequest#getOrganizationIds() organizationIds} elements
   *    .spaceId|addAllSpaceIds(String) // {@link ListAuditEventsRequest#getSpaceIds() spaceIds} elements
   *    .targetId|addAllTargetIds(String) // {@link ListAuditEventsRequest#getTargetIds() targetIds} elements
   *    .type|addAllTypes(String) // {@link ListAuditEventsRequest#getTypes() types} elements
   *    .build();
   * </pre>
   * @return A new ListAuditEventsRequest builder
   */
  public static ListAuditEventsRequest.Builder builder() {
    return new ListAuditEventsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListAuditEventsRequest ListAuditEventsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListAuditEventsRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();
    private List<String> targetIds = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListAuditEventsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListAuditEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListAuditEventsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListAuditEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.auditevents._ListAuditEventsRequest) {
        org.cloudfoundry.client.v3.auditevents._ListAuditEventsRequest instance = (org.cloudfoundry.client.v3.auditevents._ListAuditEventsRequest) object;
        addAllTypes(instance.getTypes());
        addAllSpaceIds(instance.getSpaceIds());
        addAllTargetIds(instance.getTargetIds());
        addAllOrganizationIds(instance.getOrganizationIds());
      }
    }

    /**
     * Initializes the value for the {@link ListAuditEventsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListAuditEventsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListAuditEventsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListAuditEventsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListAuditEventsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListAuditEventsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListAuditEventsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListAuditEventsRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListAuditEventsRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListAuditEventsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListAuditEventsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListAuditEventsRequest#getTargetIds() targetIds} list.
     * @param element A targetIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetId(String element) {
      this.targetIds.add(Objects.requireNonNull(element, "targetIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListAuditEventsRequest#getTargetIds() targetIds} list.
     * @param elements An array of targetIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetIds(String... elements) {
      for (String element : elements) {
        this.targetIds.add(Objects.requireNonNull(element, "targetIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListAuditEventsRequest#getTargetIds() targetIds} list.
     * @param elements An iterable of targetIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetIds(Iterable<String> elements) {
      this.targetIds.clear();
      return addAllTargetIds(elements);
    }

    /**
     * Adds elements to {@link ListAuditEventsRequest#getTargetIds() targetIds} list.
     * @param elements An iterable of targetIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTargetIds(Iterable<String> elements) {
      for (String element : elements) {
        this.targetIds.add(Objects.requireNonNull(element, "targetIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListAuditEventsRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String element) {
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link ListAuditEventsRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(String... elements) {
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListAuditEventsRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(Iterable<String> elements) {
      this.types.clear();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link ListAuditEventsRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<String> elements) {
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListAuditEventsRequest ListAuditEventsRequest}.
     * @return An immutable instance of ListAuditEventsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListAuditEventsRequest build() {
      return new ListAuditEventsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
