package org.cloudfoundry.client.v3.buildpacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Buildpack
 */
@Generated(from = "_CreateBuildpackRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateBuildpackRequest
    extends org.cloudfoundry.client.v3.buildpacks._CreateBuildpackRequest {
  private final @Nullable Boolean enabled;
  private final @Nullable Boolean locked;
  private final @Nullable Metadata metadata;
  private final String name;
  private final @Nullable Integer position;
  private final @Nullable String stack;

  private CreateBuildpackRequest(CreateBuildpackRequest.Builder builder) {
    this.enabled = builder.enabled;
    this.locked = builder.locked;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.position = builder.position;
    this.stack = builder.stack;
  }

  /**
   * Whether the buildpack is enabled
   */
  @JsonProperty("enabled")
  @Override
  public @Nullable Boolean getEnabled() {
    return enabled;
  }

  /**
   * Whether the buildpack is locked
   */
  @JsonProperty("locked")
  @Override
  public @Nullable Boolean getLocked() {
    return locked;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The position
   */
  @JsonProperty("position")
  @Override
  public @Nullable Integer getPosition() {
    return position;
  }

  /**
   * The stack
   */
  @JsonProperty("stack")
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * This instance is equal to all instances of {@code CreateBuildpackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateBuildpackRequest
        && equalTo(0, (CreateBuildpackRequest) another);
  }

  private boolean equalTo(int synthetic, CreateBuildpackRequest another) {
    return Objects.equals(enabled, another.enabled)
        && Objects.equals(locked, another.locked)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && Objects.equals(position, another.position)
        && Objects.equals(stack, another.stack);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code locked}, {@code metadata}, {@code name}, {@code position}, {@code stack}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(locked);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(position);
    h += (h << 5) + Objects.hashCode(stack);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateBuildpackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateBuildpackRequest{"
        + "enabled=" + enabled
        + ", locked=" + locked
        + ", metadata=" + metadata
        + ", name=" + name
        + ", position=" + position
        + ", stack=" + stack
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateBuildpackRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.buildpacks._CreateBuildpackRequest {
    Boolean enabled;
    Boolean locked;
    Metadata metadata;
    String name;
    Integer position;
    String stack;
    @JsonProperty("enabled")
    public void setEnabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
    }
    @JsonProperty("locked")
    public void setLocked(@Nullable Boolean locked) {
      this.locked = locked;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("position")
    public void setPosition(@Nullable Integer position) {
      this.position = position;
    }
    @JsonProperty("stack")
    public void setStack(@Nullable String stack) {
      this.stack = stack;
    }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLocked() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPosition() { throw new UnsupportedOperationException(); }
    @Override
    public String getStack() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateBuildpackRequest fromJson(Json json) {
    CreateBuildpackRequest.Builder builder = CreateBuildpackRequest.builder();
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    if (json.locked != null) {
      builder.locked(json.locked);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.position != null) {
      builder.position(json.position);
    }
    if (json.stack != null) {
      builder.stack(json.stack);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateBuildpackRequest CreateBuildpackRequest}.
   * <pre>
   * CreateBuildpackRequest.builder()
   *    .enabled(Boolean | null) // nullable {@link CreateBuildpackRequest#getEnabled() enabled}
   *    .locked(Boolean | null) // nullable {@link CreateBuildpackRequest#getLocked() locked}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateBuildpackRequest#getMetadata() metadata}
   *    .name(String) // required {@link CreateBuildpackRequest#getName() name}
   *    .position(Integer | null) // nullable {@link CreateBuildpackRequest#getPosition() position}
   *    .stack(String | null) // nullable {@link CreateBuildpackRequest#getStack() stack}
   *    .build();
   * </pre>
   * @return A new CreateBuildpackRequest builder
   */
  public static CreateBuildpackRequest.Builder builder() {
    return new CreateBuildpackRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateBuildpackRequest CreateBuildpackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateBuildpackRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Boolean enabled;
    private Boolean locked;
    private Metadata metadata;
    private String name;
    private Integer position;
    private String stack;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateBuildpackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateBuildpackRequest instance) {
      return from((_CreateBuildpackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateBuildpackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateBuildpackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean enabledValue = instance.getEnabled();
      if (enabledValue != null) {
        enabled(enabledValue);
      }
      Boolean lockedValue = instance.getLocked();
      if (lockedValue != null) {
        locked(lockedValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      name(instance.getName());
      Integer positionValue = instance.getPosition();
      if (positionValue != null) {
        position(positionValue);
      }
      String stackValue = instance.getStack();
      if (stackValue != null) {
        stack(stackValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildpackRequest#getEnabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildpackRequest#getLocked() locked} attribute.
     * @param locked The value for locked (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder locked(@Nullable Boolean locked) {
      this.locked = locked;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildpackRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildpackRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildpackRequest#getPosition() position} attribute.
     * @param position The value for position (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder position(@Nullable Integer position) {
      this.position = position;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildpackRequest#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Builds a new {@link CreateBuildpackRequest CreateBuildpackRequest}.
     * @return An immutable instance of CreateBuildpackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateBuildpackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateBuildpackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateBuildpackRequest, some of required attributes are not set " + attributes;
    }
  }
}
