package org.cloudfoundry.client.v3.buildpacks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload to Upload a Buildpack
 */
@Generated(from = "_UploadBuildpackRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UploadBuildpackRequest
    extends org.cloudfoundry.client.v3.buildpacks._UploadBuildpackRequest {
  private final Path bits;
  private final String buildpackId;

  private UploadBuildpackRequest(UploadBuildpackRequest.Builder builder) {
    this.bits = builder.bits;
    this.buildpackId = builder.buildpackId;
  }

  /**
   * The bits
   */
  @Override
  public Path getBits() {
    return bits;
  }

  /**
   * The buildpack id
   */
  @Override
  public String getBuildpackId() {
    return buildpackId;
  }

  /**
   * This instance is equal to all instances of {@code UploadBuildpackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UploadBuildpackRequest
        && equalTo(0, (UploadBuildpackRequest) another);
  }

  private boolean equalTo(int synthetic, UploadBuildpackRequest another) {
    return bits.equals(another.bits)
        && buildpackId.equals(another.buildpackId);
  }

  /**
   * Computes a hash code from attributes: {@code bits}, {@code buildpackId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + bits.hashCode();
    h += (h << 5) + buildpackId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UploadBuildpackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UploadBuildpackRequest{"
        + "bits=" + bits
        + ", buildpackId=" + buildpackId
        + "}";
  }

  /**
   * Creates a builder for {@link UploadBuildpackRequest UploadBuildpackRequest}.
   * <pre>
   * UploadBuildpackRequest.builder()
   *    .bits(java.nio.file.Path) // required {@link UploadBuildpackRequest#getBits() bits}
   *    .buildpackId(String) // required {@link UploadBuildpackRequest#getBuildpackId() buildpackId}
   *    .build();
   * </pre>
   * @return A new UploadBuildpackRequest builder
   */
  public static UploadBuildpackRequest.Builder builder() {
    return new UploadBuildpackRequest.Builder();
  }

  /**
   * Builds instances of type {@link UploadBuildpackRequest UploadBuildpackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UploadBuildpackRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BITS = 0x1L;
    private static final long INIT_BIT_BUILDPACK_ID = 0x2L;
    private long initBits = 0x3L;

    private Path bits;
    private String buildpackId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UploadBuildpackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UploadBuildpackRequest instance) {
      return from((_UploadBuildpackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UploadBuildpackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UploadBuildpackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      bits(instance.getBits());
      buildpackId(instance.getBuildpackId());
      return this;
    }

    /**
     * Initializes the value for the {@link UploadBuildpackRequest#getBits() bits} attribute.
     * @param bits The value for bits 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bits(Path bits) {
      this.bits = Objects.requireNonNull(bits, "bits");
      initBits &= ~INIT_BIT_BITS;
      return this;
    }

    /**
     * Initializes the value for the {@link UploadBuildpackRequest#getBuildpackId() buildpackId} attribute.
     * @param buildpackId The value for buildpackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpackId(String buildpackId) {
      this.buildpackId = Objects.requireNonNull(buildpackId, "buildpackId");
      initBits &= ~INIT_BIT_BUILDPACK_ID;
      return this;
    }

    /**
     * Builds a new {@link UploadBuildpackRequest UploadBuildpackRequest}.
     * @return An immutable instance of UploadBuildpackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UploadBuildpackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UploadBuildpackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BITS) != 0) attributes.add("bits");
      if ((initBits & INIT_BIT_BUILDPACK_ID) != 0) attributes.add("buildpackId");
      return "Cannot build UploadBuildpackRequest, some of required attributes are not set " + attributes;
    }
  }
}
