package org.cloudfoundry.client.v3.builds;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Represents a droplet
 */
@Generated(from = "_Droplet", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Droplet extends org.cloudfoundry.client.v3.builds._Droplet {
  private final @Nullable String href;
  private final String id;

  private Droplet(Droplet.Builder builder) {
    this.href = builder.href;
    this.id = builder.id;
  }

  /**
   * The href
   */
  @JsonProperty("href")
  @Override
  public @Nullable String getHref() {
    return href;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * This instance is equal to all instances of {@code Droplet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Droplet
        && equalTo(0, (Droplet) another);
  }

  private boolean equalTo(int synthetic, Droplet another) {
    return Objects.equals(href, another.href)
        && id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code href}, {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(href);
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Droplet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Droplet{"
        + "href=" + href
        + ", id=" + id
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Droplet", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.builds._Droplet {
    String href;
    String id;
    @JsonProperty("href")
    public void setHref(@Nullable String href) {
      this.href = href;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @Override
    public String getHref() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Droplet fromJson(Json json) {
    Droplet.Builder builder = Droplet.builder();
    if (json.href != null) {
      builder.href(json.href);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Droplet Droplet}.
   * <pre>
   * Droplet.builder()
   *    .href(String | null) // nullable {@link Droplet#getHref() href}
   *    .id(String) // required {@link Droplet#getId() id}
   *    .build();
   * </pre>
   * @return A new Droplet builder
   */
  public static Droplet.Builder builder() {
    return new Droplet.Builder();
  }

  /**
   * Builds instances of type {@link Droplet Droplet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Droplet", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private String href;
    private String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Droplet} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Droplet instance) {
      return from((_Droplet) instance);
    }

    /**
     * Copy abstract value type {@code _Droplet} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Droplet instance) {
      Objects.requireNonNull(instance, "instance");
      String hrefValue = instance.getHref();
      if (hrefValue != null) {
        href(hrefValue);
      }
      id(instance.getId());
      return this;
    }

    /**
     * Initializes the value for the {@link Droplet#getHref() href} attribute.
     * @param href The value for href (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("href")
    public final Builder href(@Nullable String href) {
      this.href = href;
      return this;
    }

    /**
     * Initializes the value for the {@link Droplet#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link Droplet Droplet}.
     * @return An immutable instance of Droplet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Droplet build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Droplet(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Droplet, some of required attributes are not set " + attributes;
    }
  }
}
