package org.cloudfoundry.client.v3.builds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Builds operation
 */
@Generated(from = "_ListBuildsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListBuildsRequest extends org.cloudfoundry.client.v3.builds._ListBuildsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> applicationIds;
  private final List<String> packageIds;
  private final List<String> states;

  private ListBuildsRequest(ListBuildsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.packageIds = createUnmodifiableList(true, builder.packageIds);
    this.states = createUnmodifiableList(true, builder.states);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The application ids
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The package ids
   */
  @Override
  public List<String> getPackageIds() {
    return packageIds;
  }

  /**
   * The build states
   */
  @Override
  public List<String> getStates() {
    return states;
  }

  /**
   * This instance is equal to all instances of {@code ListBuildsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListBuildsRequest
        && equalTo(0, (ListBuildsRequest) another);
  }

  private boolean equalTo(int synthetic, ListBuildsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationIds.equals(another.applicationIds)
        && packageIds.equals(another.packageIds)
        && states.equals(another.states);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationIds}, {@code packageIds}, {@code states}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + packageIds.hashCode();
    h += (h << 5) + states.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListBuildsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListBuildsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationIds=" + applicationIds
        + ", packageIds=" + packageIds
        + ", states=" + states
        + "}";
  }

  /**
   * Creates a builder for {@link ListBuildsRequest ListBuildsRequest}.
   * <pre>
   * ListBuildsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListBuildsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListBuildsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListBuildsRequest#getPerPage() perPage}
   *    .applicationId|addAllApplicationIds(String) // {@link ListBuildsRequest#getApplicationIds() applicationIds} elements
   *    .packageId|addAllPackageIds(String) // {@link ListBuildsRequest#getPackageIds() packageIds} elements
   *    .state|addAllStates(String) // {@link ListBuildsRequest#getStates() states} elements
   *    .build();
   * </pre>
   * @return A new ListBuildsRequest builder
   */
  public static ListBuildsRequest.Builder builder() {
    return new ListBuildsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListBuildsRequest ListBuildsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListBuildsRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> packageIds = new ArrayList<String>();
    private List<String> states = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListBuildsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListBuildsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListBuildsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListBuildsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.builds._ListBuildsRequest) {
        org.cloudfoundry.client.v3.builds._ListBuildsRequest instance = (org.cloudfoundry.client.v3.builds._ListBuildsRequest) object;
        addAllPackageIds(instance.getPackageIds());
        addAllApplicationIds(instance.getApplicationIds());
        addAllStates(instance.getStates());
      }
    }

    /**
     * Initializes the value for the {@link ListBuildsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListBuildsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListBuildsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListBuildsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListBuildsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListBuildsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListBuildsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListBuildsRequest#getPackageIds() packageIds} list.
     * @param element A packageIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String element) {
      this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListBuildsRequest#getPackageIds() packageIds} list.
     * @param elements An array of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageIds(String... elements) {
      for (String element : elements) {
        this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListBuildsRequest#getPackageIds() packageIds} list.
     * @param elements An iterable of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageIds(Iterable<String> elements) {
      this.packageIds.clear();
      return addAllPackageIds(elements);
    }

    /**
     * Adds elements to {@link ListBuildsRequest#getPackageIds() packageIds} list.
     * @param elements An iterable of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPackageIds(Iterable<String> elements) {
      for (String element : elements) {
        this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListBuildsRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(String element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link ListBuildsRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(String... elements) {
      for (String element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListBuildsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<String> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link ListBuildsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<String> elements) {
      for (String element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListBuildsRequest ListBuildsRequest}.
     * @return An immutable instance of ListBuildsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListBuildsRequest build() {
      return new ListBuildsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
