package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Deployment operation
 */
@Generated(from = "_CreateDeploymentRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateDeploymentRequest
    extends org.cloudfoundry.client.v3.deployments._CreateDeploymentRequest {
  private final @Nullable Relationship droplet;
  private final DeploymentRelationships relationships;

  private CreateDeploymentRequest(CreateDeploymentRequest.Builder builder) {
    this.droplet = builder.droplet;
    this.relationships = builder.relationships;
  }

  /**
   * The droplet
   */
  @JsonProperty("droplet")
  @Override
  public @Nullable Relationship getDroplet() {
    return droplet;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public DeploymentRelationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code CreateDeploymentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateDeploymentRequest
        && equalTo(0, (CreateDeploymentRequest) another);
  }

  private boolean equalTo(int synthetic, CreateDeploymentRequest another) {
    return Objects.equals(droplet, another.droplet)
        && relationships.equals(another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code droplet}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(droplet);
    h += (h << 5) + relationships.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateDeploymentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateDeploymentRequest{"
        + "droplet=" + droplet
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateDeploymentRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.deployments._CreateDeploymentRequest {
    Relationship droplet;
    DeploymentRelationships relationships;
    @JsonProperty("droplet")
    public void setDroplet(@Nullable Relationship droplet) {
      this.droplet = droplet;
    }
    @JsonProperty("relationships")
    public void setRelationships(DeploymentRelationships relationships) {
      this.relationships = relationships;
    }
    @Override
    public Relationship getDroplet() { throw new UnsupportedOperationException(); }
    @Override
    public DeploymentRelationships getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateDeploymentRequest fromJson(Json json) {
    CreateDeploymentRequest.Builder builder = CreateDeploymentRequest.builder();
    if (json.droplet != null) {
      builder.droplet(json.droplet);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateDeploymentRequest CreateDeploymentRequest}.
   * <pre>
   * CreateDeploymentRequest.builder()
   *    .droplet(org.cloudfoundry.client.v3.Relationship | null) // nullable {@link CreateDeploymentRequest#getDroplet() droplet}
   *    .relationships(org.cloudfoundry.client.v3.deployments.DeploymentRelationships) // required {@link CreateDeploymentRequest#getRelationships() relationships}
   *    .build();
   * </pre>
   * @return A new CreateDeploymentRequest builder
   */
  public static CreateDeploymentRequest.Builder builder() {
    return new CreateDeploymentRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateDeploymentRequest CreateDeploymentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateDeploymentRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_RELATIONSHIPS = 0x1L;
    private long initBits = 0x1L;

    private Relationship droplet;
    private DeploymentRelationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateDeploymentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateDeploymentRequest instance) {
      return from((_CreateDeploymentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateDeploymentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateDeploymentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Relationship dropletValue = instance.getDroplet();
      if (dropletValue != null) {
        droplet(dropletValue);
      }
      relationships(instance.getRelationships());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDeploymentRequest#getDroplet() droplet} attribute.
     * @param droplet The value for droplet (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder droplet(@Nullable Relationship droplet) {
      this.droplet = droplet;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDeploymentRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(DeploymentRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Builds a new {@link CreateDeploymentRequest CreateDeploymentRequest}.
     * @return An immutable instance of CreateDeploymentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateDeploymentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateDeploymentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      return "Cannot build CreateDeploymentRequest, some of required attributes are not set " + attributes;
    }
  }
}
