package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Create a Domain operation
 */
@Generated(from = "_CreateDomainRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateDomainRequest extends org.cloudfoundry.client.v3.domains._CreateDomainRequest {
  private final @Nullable Boolean internal;
  private final @Nullable Metadata metadata;
  private final String name;
  private final @Nullable DomainRelationships relationships;

  private CreateDomainRequest(CreateDomainRequest.Builder builder) {
    this.internal = builder.internal;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.relationships = builder.relationships;
  }

  /**
   * Whether this is an internal domain
   */
  @JsonProperty("internal")
  @Override
  public @Nullable Boolean getInternal() {
    return internal;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable DomainRelationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code CreateDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateDomainRequest
        && equalTo(0, (CreateDomainRequest) another);
  }

  private boolean equalTo(int synthetic, CreateDomainRequest another) {
    return Objects.equals(internal, another.internal)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && Objects.equals(relationships, another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code internal}, {@code metadata}, {@code name}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(internal);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(relationships);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateDomainRequest{"
        + "internal=" + internal
        + ", metadata=" + metadata
        + ", name=" + name
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateDomainRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._CreateDomainRequest {
    Boolean internal;
    Metadata metadata;
    String name;
    DomainRelationships relationships;
    @JsonProperty("internal")
    public void setInternal(@Nullable Boolean internal) {
      this.internal = internal;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable DomainRelationships relationships) {
      this.relationships = relationships;
    }
    @Override
    public Boolean getInternal() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public DomainRelationships getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateDomainRequest fromJson(Json json) {
    CreateDomainRequest.Builder builder = CreateDomainRequest.builder();
    if (json.internal != null) {
      builder.internal(json.internal);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateDomainRequest CreateDomainRequest}.
   * <pre>
   * CreateDomainRequest.builder()
   *    .internal(Boolean | null) // nullable {@link CreateDomainRequest#getInternal() internal}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateDomainRequest#getMetadata() metadata}
   *    .name(String) // required {@link CreateDomainRequest#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.domains.DomainRelationships | null) // nullable {@link CreateDomainRequest#getRelationships() relationships}
   *    .build();
   * </pre>
   * @return A new CreateDomainRequest builder
   */
  public static CreateDomainRequest.Builder builder() {
    return new CreateDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateDomainRequest CreateDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateDomainRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Boolean internal;
    private Metadata metadata;
    private String name;
    private DomainRelationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateDomainRequest instance) {
      return from((_CreateDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean internalValue = instance.getInternal();
      if (internalValue != null) {
        internal(internalValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      name(instance.getName());
      DomainRelationships relationshipsValue = instance.getRelationships();
      if (relationshipsValue != null) {
        relationships(relationshipsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainRequest#getInternal() internal} attribute.
     * @param internal The value for internal (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder internal(@Nullable Boolean internal) {
      this.internal = internal;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(@Nullable DomainRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Builds a new {@link CreateDomainRequest CreateDomainRequest}.
     * @return An immutable instance of CreateDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
