package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The response payload for the Share Domain operation
 */
@Generated(from = "_ShareDomainResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ShareDomainResponse extends org.cloudfoundry.client.v3.domains._ShareDomainResponse {
  private final @Nullable List<Relationship> data;

  private ShareDomainResponse(ShareDomainResponse.Builder builder) {
    this.data = builder.data == null ? null : createUnmodifiableList(true, builder.data);
  }

  /**
   * The data
   */
  @JsonProperty("data")
  @Override
  public @Nullable List<Relationship> getData() {
    return data;
  }

  /**
   * This instance is equal to all instances of {@code ShareDomainResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ShareDomainResponse
        && equalTo(0, (ShareDomainResponse) another);
  }

  private boolean equalTo(int synthetic, ShareDomainResponse another) {
    return Objects.equals(data, another.data);
  }

  /**
   * Computes a hash code from attributes: {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    return h;
  }

  /**
   * Prints the immutable value {@code ShareDomainResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ShareDomainResponse{"
        + "data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ShareDomainResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._ShareDomainResponse {
    List<Relationship> data = null;
    @JsonProperty("data")
    public void setData(@Nullable List<Relationship> data) {
      this.data = data;
    }
    @Override
    public List<Relationship> getData() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ShareDomainResponse fromJson(Json json) {
    ShareDomainResponse.Builder builder = ShareDomainResponse.builder();
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ShareDomainResponse ShareDomainResponse}.
   * <pre>
   * ShareDomainResponse.builder()
   *    .data(List&amp;lt;org.cloudfoundry.client.v3.Relationship&amp;gt; | null) // nullable {@link ShareDomainResponse#getData() data}
   *    .build();
   * </pre>
   * @return A new ShareDomainResponse builder
   */
  public static ShareDomainResponse.Builder builder() {
    return new ShareDomainResponse.Builder();
  }

  /**
   * Builds instances of type {@link ShareDomainResponse ShareDomainResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ShareDomainResponse", generator = "Immutables")
  public static final class Builder {
    private List<Relationship> data = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ShareDomainResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ShareDomainResponse instance) {
      return from((_ShareDomainResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ShareDomainResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ShareDomainResponse instance) {
      Objects.requireNonNull(instance, "instance");
      List<Relationship> dataValue = instance.getData();
      if (dataValue != null) {
        addAllData(dataValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link ShareDomainResponse#getData() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship element) {
      if (this.data == null) {
        this.data = new ArrayList<Relationship>();
      }
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link ShareDomainResponse#getData() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship... elements) {
      if (this.data == null) {
        this.data = new ArrayList<Relationship>();
      }
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ShareDomainResponse#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Iterable<? extends Relationship> elements) {
      if (elements == null) {
        this.data = null;
        return this;
      }
      this.data = new ArrayList<Relationship>();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link ShareDomainResponse#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends Relationship> elements) {
      Objects.requireNonNull(elements, "data element");
      if (this.data == null) {
        this.data = new ArrayList<Relationship>();
      }
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ShareDomainResponse ShareDomainResponse}.
     * @return An immutable instance of ShareDomainResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ShareDomainResponse build() {
      return new ShareDomainResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
