package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Isolation Segment operation.
 */
@Generated(from = "_GetIsolationSegmentRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetIsolationSegmentRequest
    extends org.cloudfoundry.client.v3.isolationsegments._GetIsolationSegmentRequest {
  private final String isolationSegmentId;

  private GetIsolationSegmentRequest(GetIsolationSegmentRequest.Builder builder) {
    this.isolationSegmentId = builder.isolationSegmentId;
  }

  /**
   * The id of the isolation segment
   */
  @Override
  public String getIsolationSegmentId() {
    return isolationSegmentId;
  }

  /**
   * This instance is equal to all instances of {@code GetIsolationSegmentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetIsolationSegmentRequest
        && equalTo(0, (GetIsolationSegmentRequest) another);
  }

  private boolean equalTo(int synthetic, GetIsolationSegmentRequest another) {
    return isolationSegmentId.equals(another.isolationSegmentId);
  }

  /**
   * Computes a hash code from attributes: {@code isolationSegmentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + isolationSegmentId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetIsolationSegmentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetIsolationSegmentRequest{"
        + "isolationSegmentId=" + isolationSegmentId
        + "}";
  }

  /**
   * Creates a builder for {@link GetIsolationSegmentRequest GetIsolationSegmentRequest}.
   * <pre>
   * GetIsolationSegmentRequest.builder()
   *    .isolationSegmentId(String) // required {@link GetIsolationSegmentRequest#getIsolationSegmentId() isolationSegmentId}
   *    .build();
   * </pre>
   * @return A new GetIsolationSegmentRequest builder
   */
  public static GetIsolationSegmentRequest.Builder builder() {
    return new GetIsolationSegmentRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetIsolationSegmentRequest GetIsolationSegmentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetIsolationSegmentRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ISOLATION_SEGMENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String isolationSegmentId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetIsolationSegmentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetIsolationSegmentRequest instance) {
      return from((_GetIsolationSegmentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetIsolationSegmentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetIsolationSegmentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      isolationSegmentId(instance.getIsolationSegmentId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetIsolationSegmentRequest#getIsolationSegmentId() isolationSegmentId} attribute.
     * @param isolationSegmentId The value for isolationSegmentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentId(String isolationSegmentId) {
      this.isolationSegmentId = Objects.requireNonNull(isolationSegmentId, "isolationSegmentId");
      initBits &= ~INIT_BIT_ISOLATION_SEGMENT_ID;
      return this;
    }

    /**
     * Builds a new {@link GetIsolationSegmentRequest GetIsolationSegmentRequest}.
     * @return An immutable instance of GetIsolationSegmentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetIsolationSegmentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetIsolationSegmentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ISOLATION_SEGMENT_ID) != 0) attributes.add("isolationSegmentId");
      return "Cannot build GetIsolationSegmentRequest, some of required attributes are not set " + attributes;
    }
  }
}
