package org.cloudfoundry.client.v3.jobs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Error;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Job operation
 */
@Generated(from = "_GetJobResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetJobResponse extends org.cloudfoundry.client.v3.jobs._GetJobResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final List<Error> errors;
  private final String operation;
  private final JobState state;
  private final List<Warning> warnings;

  private GetJobResponse(GetJobResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.errors = createUnmodifiableList(true, builder.errors);
    this.operation = builder.operation;
    this.state = builder.state;
    this.warnings = createUnmodifiableList(true, builder.warnings);
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * Collection of errors that occurred while processing the job.
   */
  @JsonProperty("errors")
  @Override
  public List<Error> getErrors() {
    return errors;
  }

  /**
   * Current desired operation of the job
   */
  @JsonProperty("operation")
  @Override
  public String getOperation() {
    return operation;
  }

  /**
   * State of the job
   */
  @JsonProperty("state")
  @Override
  public JobState getState() {
    return state;
  }

  /**
   * Collection of warnings that occurred while processing the job.
   */
  @JsonProperty("warnings")
  @Override
  public List<Warning> getWarnings() {
    return warnings;
  }

  /**
   * This instance is equal to all instances of {@code GetJobResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetJobResponse
        && equalTo(0, (GetJobResponse) another);
  }

  private boolean equalTo(int synthetic, GetJobResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && errors.equals(another.errors)
        && operation.equals(another.operation)
        && state.equals(another.state)
        && warnings.equals(another.warnings);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code errors}, {@code operation}, {@code state}, {@code warnings}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + errors.hashCode();
    h += (h << 5) + operation.hashCode();
    h += (h << 5) + state.hashCode();
    h += (h << 5) + warnings.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetJobResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetJobResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", errors=" + errors
        + ", operation=" + operation
        + ", state=" + state
        + ", warnings=" + warnings
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetJobResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.jobs._GetJobResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    List<Error> errors = Collections.emptyList();
    String operation;
    JobState state;
    List<Warning> warnings = Collections.emptyList();
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("errors")
    public void setErrors(List<Error> errors) {
      this.errors = errors;
    }
    @JsonProperty("operation")
    public void setOperation(String operation) {
      this.operation = operation;
    }
    @JsonProperty("state")
    public void setState(JobState state) {
      this.state = state;
    }
    @JsonProperty("warnings")
    public void setWarnings(List<Warning> warnings) {
      this.warnings = warnings;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public List<Error> getErrors() { throw new UnsupportedOperationException(); }
    @Override
    public String getOperation() { throw new UnsupportedOperationException(); }
    @Override
    public JobState getState() { throw new UnsupportedOperationException(); }
    @Override
    public List<Warning> getWarnings() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetJobResponse fromJson(Json json) {
    GetJobResponse.Builder builder = GetJobResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    if (json.operation != null) {
      builder.operation(json.operation);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.warnings != null) {
      builder.addAllWarnings(json.warnings);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetJobResponse GetJobResponse}.
   * <pre>
   * GetJobResponse.builder()
   *    .createdAt(String) // required {@link GetJobResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetJobResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link GetJobResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetJobResponse#getUpdatedAt() updatedAt}
   *    .error|addAllErrors(org.cloudfoundry.client.v3.Error) // {@link GetJobResponse#getErrors() errors} elements
   *    .operation(String) // required {@link GetJobResponse#getOperation() operation}
   *    .state(org.cloudfoundry.client.v3.jobs.JobState) // required {@link GetJobResponse#getState() state}
   *    .warning|addAllWarnings(Warning) // {@link GetJobResponse#getWarnings() warnings} elements
   *    .build();
   * </pre>
   * @return A new GetJobResponse builder
   */
  public static GetJobResponse.Builder builder() {
    return new GetJobResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetJobResponse GetJobResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetJobResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_OPERATION = 0x4L;
    private static final long INIT_BIT_STATE = 0x8L;
    private long initBits = 0xfL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private List<Error> errors = new ArrayList<Error>();
    private String operation;
    private JobState state;
    private List<Warning> warnings = new ArrayList<Warning>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetJobResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetJobResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetJobResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetJobResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.jobs.Job} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Job instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof org.cloudfoundry.client.v3.jobs._GetJobResponse) {
        org.cloudfoundry.client.v3.jobs._GetJobResponse instance = (org.cloudfoundry.client.v3.jobs._GetJobResponse) object;
        if ((bits & 0x10L) == 0) {
          state(instance.getState());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          operation(instance.getOperation());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          addAllErrors(instance.getErrors());
          bits |= 0x40L;
        }
        if ((bits & 0x1L) == 0) {
          addAllWarnings(instance.getWarnings());
          bits |= 0x1L;
        }
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x2L) == 0) {
          createdAt(instance.getCreatedAt());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          id(instance.getId());
          bits |= 0x8L;
        }
        if ((bits & 0x80L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x80L;
        }
      }
      if (object instanceof Job) {
        Job instance = (Job) object;
        if ((bits & 0x2L) == 0) {
          createdAt(instance.getCreatedAt());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          addAllWarnings(instance.getWarnings());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          id(instance.getId());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          state(instance.getState());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          operation(instance.getOperation());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          addAllErrors(instance.getErrors());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x80L;
        }
      }
    }

    /**
     * Initializes the value for the {@link GetJobResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetJobResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetJobResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetJobResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetJobResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetJobResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetJobResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Adds one element to {@link GetJobResponse#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder error(Error element) {
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link GetJobResponse#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder errors(Error... elements) {
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetJobResponse#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    public final Builder errors(Iterable<? extends Error> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link GetJobResponse#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends Error> elements) {
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetJobResponse#getOperation() operation} attribute.
     * @param operation The value for operation 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("operation")
    public final Builder operation(String operation) {
      this.operation = Objects.requireNonNull(operation, "operation");
      initBits &= ~INIT_BIT_OPERATION;
      return this;
    }

    /**
     * Initializes the value for the {@link GetJobResponse#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(JobState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Adds one element to {@link GetJobResponse#getWarnings() warnings} list.
     * @param element A warnings element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder warning(Warning element) {
      this.warnings.add(Objects.requireNonNull(element, "warnings element"));
      return this;
    }

    /**
     * Adds elements to {@link GetJobResponse#getWarnings() warnings} list.
     * @param elements An array of warnings elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder warnings(Warning... elements) {
      for (Warning element : elements) {
        this.warnings.add(Objects.requireNonNull(element, "warnings element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetJobResponse#getWarnings() warnings} list.
     * @param elements An iterable of warnings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("warnings")
    public final Builder warnings(Iterable<? extends Warning> elements) {
      this.warnings.clear();
      return addAllWarnings(elements);
    }

    /**
     * Adds elements to {@link GetJobResponse#getWarnings() warnings} list.
     * @param elements An iterable of warnings elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllWarnings(Iterable<? extends Warning> elements) {
      for (Warning element : elements) {
        this.warnings.add(Objects.requireNonNull(element, "warnings element"));
      }
      return this;
    }

    /**
     * Builds a new {@link GetJobResponse GetJobResponse}.
     * @return An immutable instance of GetJobResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetJobResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetJobResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_OPERATION) != 0) attributes.add("operation");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      return "Cannot build GetJobResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
