package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The request payload for the Assign Default Isolation Segment operation
 */
@Generated(from = "_AssignOrganizationDefaultIsolationSegmentRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AssignOrganizationDefaultIsolationSegmentRequest
    extends org.cloudfoundry.client.v3.organizations._AssignOrganizationDefaultIsolationSegmentRequest {
  private final @Nullable Relationship data;
  private final String organizationId;

  private AssignOrganizationDefaultIsolationSegmentRequest(AssignOrganizationDefaultIsolationSegmentRequest.Builder builder) {
    this.data = builder.data;
    this.organizationId = builder.organizationId;
  }

  /**
   * The isolation segment to assign
   */
  @JsonProperty("data")
  @Override
  public @Nullable Relationship getData() {
    return data;
  }

  /**
   * The organization id
   */
  @JsonProperty("organizationId")
  @JsonIgnore
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code AssignOrganizationDefaultIsolationSegmentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssignOrganizationDefaultIsolationSegmentRequest
        && equalTo(0, (AssignOrganizationDefaultIsolationSegmentRequest) another);
  }

  private boolean equalTo(int synthetic, AssignOrganizationDefaultIsolationSegmentRequest another) {
    return Objects.equals(data, another.data)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssignOrganizationDefaultIsolationSegmentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssignOrganizationDefaultIsolationSegmentRequest{"
        + "data=" + data
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_AssignOrganizationDefaultIsolationSegmentRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.organizations._AssignOrganizationDefaultIsolationSegmentRequest {
    Relationship data;
    String organizationId;
    @JsonProperty("data")
    public void setData(@Nullable Relationship data) {
      this.data = data;
    }
    @JsonProperty("organizationId")
    @JsonIgnore
    public void setOrganizationId(String organizationId) {
      this.organizationId = organizationId;
    }
    @Override
    public Relationship getData() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static AssignOrganizationDefaultIsolationSegmentRequest fromJson(Json json) {
    AssignOrganizationDefaultIsolationSegmentRequest.Builder builder = AssignOrganizationDefaultIsolationSegmentRequest.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AssignOrganizationDefaultIsolationSegmentRequest AssignOrganizationDefaultIsolationSegmentRequest}.
   * <pre>
   * AssignOrganizationDefaultIsolationSegmentRequest.builder()
   *    .data(org.cloudfoundry.client.v3.Relationship | null) // nullable {@link AssignOrganizationDefaultIsolationSegmentRequest#getData() data}
   *    .organizationId(String) // required {@link AssignOrganizationDefaultIsolationSegmentRequest#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new AssignOrganizationDefaultIsolationSegmentRequest builder
   */
  public static AssignOrganizationDefaultIsolationSegmentRequest.Builder builder() {
    return new AssignOrganizationDefaultIsolationSegmentRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssignOrganizationDefaultIsolationSegmentRequest AssignOrganizationDefaultIsolationSegmentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AssignOrganizationDefaultIsolationSegmentRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private Relationship data;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssignOrganizationDefaultIsolationSegmentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssignOrganizationDefaultIsolationSegmentRequest instance) {
      return from((_AssignOrganizationDefaultIsolationSegmentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssignOrganizationDefaultIsolationSegmentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssignOrganizationDefaultIsolationSegmentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Relationship dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssignOrganizationDefaultIsolationSegmentRequest#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(@Nullable Relationship data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link AssignOrganizationDefaultIsolationSegmentRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link AssignOrganizationDefaultIsolationSegmentRequest AssignOrganizationDefaultIsolationSegmentRequest}.
     * @return An immutable instance of AssignOrganizationDefaultIsolationSegmentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssignOrganizationDefaultIsolationSegmentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssignOrganizationDefaultIsolationSegmentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build AssignOrganizationDefaultIsolationSegmentRequest, some of required attributes are not set " + attributes;
    }
  }
}
