package org.cloudfoundry.client.v3.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Organization Usage Summary operation
 */
@Generated(from = "_GetOrganizationUsageSummaryRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetOrganizationUsageSummaryRequest
    extends org.cloudfoundry.client.v3.organizations._GetOrganizationUsageSummaryRequest {
  private final String organizationId;

  private GetOrganizationUsageSummaryRequest(GetOrganizationUsageSummaryRequest.Builder builder) {
    this.organizationId = builder.organizationId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code GetOrganizationUsageSummaryRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOrganizationUsageSummaryRequest
        && equalTo(0, (GetOrganizationUsageSummaryRequest) another);
  }

  private boolean equalTo(int synthetic, GetOrganizationUsageSummaryRequest another) {
    return organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetOrganizationUsageSummaryRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOrganizationUsageSummaryRequest{"
        + "organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link GetOrganizationUsageSummaryRequest GetOrganizationUsageSummaryRequest}.
   * <pre>
   * GetOrganizationUsageSummaryRequest.builder()
   *    .organizationId(String) // required {@link GetOrganizationUsageSummaryRequest#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new GetOrganizationUsageSummaryRequest builder
   */
  public static GetOrganizationUsageSummaryRequest.Builder builder() {
    return new GetOrganizationUsageSummaryRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetOrganizationUsageSummaryRequest GetOrganizationUsageSummaryRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetOrganizationUsageSummaryRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOrganizationUsageSummaryRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOrganizationUsageSummaryRequest instance) {
      return from((_GetOrganizationUsageSummaryRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetOrganizationUsageSummaryRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOrganizationUsageSummaryRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetOrganizationUsageSummaryRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link GetOrganizationUsageSummaryRequest GetOrganizationUsageSummaryRequest}.
     * @return An immutable instance of GetOrganizationUsageSummaryRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOrganizationUsageSummaryRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetOrganizationUsageSummaryRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build GetOrganizationUsageSummaryRequest, some of required attributes are not set " + attributes;
    }
  }
}
