package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Organization entity
 */
@Generated(from = "_OrganizationRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OrganizationRelationships
    extends org.cloudfoundry.client.v3.organizations._OrganizationRelationships {
  private final @Nullable ToOneRelationship quota;

  private OrganizationRelationships(OrganizationRelationships.Builder builder) {
    this.quota = builder.quota;
  }

  /**
   * The quota relationship
   */
  @JsonProperty("quota")
  @Override
  public @Nullable ToOneRelationship getQuota() {
    return quota;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationRelationships
        && equalTo(0, (OrganizationRelationships) another);
  }

  private boolean equalTo(int synthetic, OrganizationRelationships another) {
    return Objects.equals(quota, another.quota);
  }

  /**
   * Computes a hash code from attributes: {@code quota}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(quota);
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationRelationships{"
        + "quota=" + quota
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_OrganizationRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.organizations._OrganizationRelationships {
    ToOneRelationship quota;
    @JsonProperty("quota")
    public void setQuota(@Nullable ToOneRelationship quota) {
      this.quota = quota;
    }
    @Override
    public ToOneRelationship getQuota() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static OrganizationRelationships fromJson(Json json) {
    OrganizationRelationships.Builder builder = OrganizationRelationships.builder();
    if (json.quota != null) {
      builder.quota(json.quota);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link OrganizationRelationships OrganizationRelationships}.
   * <pre>
   * OrganizationRelationships.builder()
   *    .quota(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link OrganizationRelationships#getQuota() quota}
   *    .build();
   * </pre>
   * @return A new OrganizationRelationships builder
   */
  public static OrganizationRelationships.Builder builder() {
    return new OrganizationRelationships.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationRelationships OrganizationRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OrganizationRelationships", generator = "Immutables")
  public static final class Builder {
    private ToOneRelationship quota;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationRelationships instance) {
      return from((_OrganizationRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      ToOneRelationship quotaValue = instance.getQuota();
      if (quotaValue != null) {
        quota(quotaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationRelationships#getQuota() quota} attribute.
     * @param quota The value for quota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("quota")
    public final Builder quota(@Nullable ToOneRelationship quota) {
      this.quota = quota;
      return this;
    }

    /**
     * Builds a new {@link OrganizationRelationships OrganizationRelationships}.
     * @return An immutable instance of OrganizationRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationRelationships build() {
      return new OrganizationRelationships(this);
    }
  }
}
