package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Checksum;
import org.immutables.value.Generated;

/**
 * Data type for bits packages
 */
@Generated(from = "_BitsData", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BitsData extends org.cloudfoundry.client.v3.packages._BitsData {
  private final @Nullable Checksum checksum;
  private final @Nullable String error;

  private BitsData(BitsData.Builder builder) {
    this.checksum = builder.checksum;
    this.error = builder.error;
  }

  /**
   * The checksum
   */
  @JsonProperty("checksum")
  @Override
  public @Nullable Checksum getChecksum() {
    return checksum;
  }

  /**
   * The error
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * This instance is equal to all instances of {@code BitsData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BitsData
        && equalTo(0, (BitsData) another);
  }

  private boolean equalTo(int synthetic, BitsData another) {
    return Objects.equals(checksum, another.checksum)
        && Objects.equals(error, another.error);
  }

  /**
   * Computes a hash code from attributes: {@code checksum}, {@code error}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(checksum);
    h += (h << 5) + Objects.hashCode(error);
    return h;
  }

  /**
   * Prints the immutable value {@code BitsData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BitsData{"
        + "checksum=" + checksum
        + ", error=" + error
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BitsData", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.packages._BitsData {
    Checksum checksum;
    String error;
    @JsonProperty("checksum")
    public void setChecksum(@Nullable Checksum checksum) {
      this.checksum = checksum;
    }
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @Override
    public Checksum getChecksum() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BitsData fromJson(Json json) {
    BitsData.Builder builder = BitsData.builder();
    if (json.checksum != null) {
      builder.checksum(json.checksum);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BitsData BitsData}.
   * <pre>
   * BitsData.builder()
   *    .checksum(org.cloudfoundry.client.v3.Checksum | null) // nullable {@link BitsData#getChecksum() checksum}
   *    .error(String | null) // nullable {@link BitsData#getError() error}
   *    .build();
   * </pre>
   * @return A new BitsData builder
   */
  public static BitsData.Builder builder() {
    return new BitsData.Builder();
  }

  /**
   * Builds instances of type {@link BitsData BitsData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BitsData", generator = "Immutables")
  public static final class Builder {
    private Checksum checksum;
    private String error;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BitsData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BitsData instance) {
      return from((_BitsData) instance);
    }

    /**
     * Copy abstract value type {@code _BitsData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BitsData instance) {
      Objects.requireNonNull(instance, "instance");
      Checksum checksumValue = instance.getChecksum();
      if (checksumValue != null) {
        checksum(checksumValue);
      }
      String errorValue = instance.getError();
      if (errorValue != null) {
        error(errorValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BitsData#getChecksum() checksum} attribute.
     * @param checksum The value for checksum (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("checksum")
    public final Builder checksum(@Nullable Checksum checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link BitsData#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Builds a new {@link BitsData BitsData}.
     * @return An immutable instance of BitsData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BitsData build() {
      return new BitsData(this);
    }
  }
}
