package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Statistics for a Process operation
 */
@Generated(from = "_GetProcessStatisticsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetProcessStatisticsRequest
    extends org.cloudfoundry.client.v3.processes._GetProcessStatisticsRequest {
  private final String processId;

  private GetProcessStatisticsRequest(GetProcessStatisticsRequest.Builder builder) {
    this.processId = builder.processId;
  }

  /**
   * The process id
   */
  @Override
  public String getProcessId() {
    return processId;
  }

  /**
   * This instance is equal to all instances of {@code GetProcessStatisticsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetProcessStatisticsRequest
        && equalTo(0, (GetProcessStatisticsRequest) another);
  }

  private boolean equalTo(int synthetic, GetProcessStatisticsRequest another) {
    return processId.equals(another.processId);
  }

  /**
   * Computes a hash code from attributes: {@code processId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + processId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetProcessStatisticsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetProcessStatisticsRequest{"
        + "processId=" + processId
        + "}";
  }

  /**
   * Creates a builder for {@link GetProcessStatisticsRequest GetProcessStatisticsRequest}.
   * <pre>
   * GetProcessStatisticsRequest.builder()
   *    .processId(String) // required {@link GetProcessStatisticsRequest#getProcessId() processId}
   *    .build();
   * </pre>
   * @return A new GetProcessStatisticsRequest builder
   */
  public static GetProcessStatisticsRequest.Builder builder() {
    return new GetProcessStatisticsRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetProcessStatisticsRequest GetProcessStatisticsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetProcessStatisticsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PROCESS_ID = 0x1L;
    private long initBits = 0x1L;

    private String processId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetProcessStatisticsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetProcessStatisticsRequest instance) {
      return from((_GetProcessStatisticsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetProcessStatisticsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetProcessStatisticsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      processId(instance.getProcessId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetProcessStatisticsRequest#getProcessId() processId} attribute.
     * @param processId The value for processId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String processId) {
      this.processId = Objects.requireNonNull(processId, "processId");
      initBits &= ~INIT_BIT_PROCESS_ID;
      return this;
    }

    /**
     * Builds a new {@link GetProcessStatisticsRequest GetProcessStatisticsRequest}.
     * @return An immutable instance of GetProcessStatisticsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetProcessStatisticsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetProcessStatisticsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROCESS_ID) != 0) attributes.add("processId");
      return "Cannot build GetProcessStatisticsRequest, some of required attributes are not set " + attributes;
    }
  }
}
