package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The health check
 */
@Generated(from = "_HealthCheck", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class HealthCheck extends org.cloudfoundry.client.v3.processes._HealthCheck {
  private final @Nullable Data data;
  private final HealthCheckType type;

  private HealthCheck(HealthCheck.Builder builder) {
    this.data = builder.data;
    this.type = builder.type;
  }

  /**
   * The data
   */
  @JsonProperty("data")
  @Override
  public @Nullable Data getData() {
    return data;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public HealthCheckType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code HealthCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof HealthCheck
        && equalTo(0, (HealthCheck) another);
  }

  private boolean equalTo(int synthetic, HealthCheck another) {
    return Objects.equals(data, another.data)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HealthCheck} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HealthCheck{"
        + "data=" + data
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_HealthCheck", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._HealthCheck {
    Data data;
    HealthCheckType type;
    @JsonProperty("data")
    public void setData(@Nullable Data data) {
      this.data = data;
    }
    @JsonProperty("type")
    public void setType(HealthCheckType type) {
      this.type = type;
    }
    @Override
    public Data getData() { throw new UnsupportedOperationException(); }
    @Override
    public HealthCheckType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static HealthCheck fromJson(Json json) {
    HealthCheck.Builder builder = HealthCheck.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link HealthCheck HealthCheck}.
   * <pre>
   * HealthCheck.builder()
   *    .data(org.cloudfoundry.client.v3.processes.Data | null) // nullable {@link HealthCheck#getData() data}
   *    .type(org.cloudfoundry.client.v3.processes.HealthCheckType) // required {@link HealthCheck#getType() type}
   *    .build();
   * </pre>
   * @return A new HealthCheck builder
   */
  public static HealthCheck.Builder builder() {
    return new HealthCheck.Builder();
  }

  /**
   * Builds instances of type {@link HealthCheck HealthCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_HealthCheck", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private Data data;
    private HealthCheckType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HealthCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HealthCheck instance) {
      return from((_HealthCheck) instance);
    }

    /**
     * Copy abstract value type {@code _HealthCheck} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_HealthCheck instance) {
      Objects.requireNonNull(instance, "instance");
      Data dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Data data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(HealthCheckType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link HealthCheck HealthCheck}.
     * @return An immutable instance of HealthCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public HealthCheck build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new HealthCheck(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build HealthCheck, some of required attributes are not set " + attributes;
    }
  }
}
