package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Scale Process operation
 */
@Generated(from = "_ScaleProcessRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ScaleProcessRequest extends org.cloudfoundry.client.v3.processes._ScaleProcessRequest {
  private final @Nullable Integer diskInMb;
  private final @Nullable Integer instances;
  private final @Nullable Integer memoryInMb;
  private final String processId;

  private ScaleProcessRequest(ScaleProcessRequest.Builder builder) {
    this.diskInMb = builder.diskInMb;
    this.instances = builder.instances;
    this.memoryInMb = builder.memoryInMb;
    this.processId = builder.processId;
  }

  /**
   * The disk in megabytes
   */
  @JsonProperty("disk_in_mb")
  @Override
  public @Nullable Integer getDiskInMb() {
    return diskInMb;
  }

  /**
   * The number of instances
   */
  @JsonProperty("instances")
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory in megabytes
   */
  @JsonProperty("memory_in_mb")
  @Override
  public @Nullable Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The process id
   */
  @JsonProperty("processId")
  @JsonIgnore
  @Override
  public String getProcessId() {
    return processId;
  }

  /**
   * This instance is equal to all instances of {@code ScaleProcessRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ScaleProcessRequest
        && equalTo(0, (ScaleProcessRequest) another);
  }

  private boolean equalTo(int synthetic, ScaleProcessRequest another) {
    return Objects.equals(diskInMb, another.diskInMb)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memoryInMb, another.memoryInMb)
        && processId.equals(another.processId);
  }

  /**
   * Computes a hash code from attributes: {@code diskInMb}, {@code instances}, {@code memoryInMb}, {@code processId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(diskInMb);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memoryInMb);
    h += (h << 5) + processId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ScaleProcessRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ScaleProcessRequest{"
        + "diskInMb=" + diskInMb
        + ", instances=" + instances
        + ", memoryInMb=" + memoryInMb
        + ", processId=" + processId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ScaleProcessRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._ScaleProcessRequest {
    Integer diskInMb;
    Integer instances;
    Integer memoryInMb;
    String processId;
    @JsonProperty("disk_in_mb")
    public void setDiskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
    }
    @JsonProperty("instances")
    public void setInstances(@Nullable Integer instances) {
      this.instances = instances;
    }
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("processId")
    @JsonIgnore
    public void setProcessId(String processId) {
      this.processId = processId;
    }
    @Override
    public Integer getDiskInMb() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public String getProcessId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ScaleProcessRequest fromJson(Json json) {
    ScaleProcessRequest.Builder builder = ScaleProcessRequest.builder();
    if (json.diskInMb != null) {
      builder.diskInMb(json.diskInMb);
    }
    if (json.instances != null) {
      builder.instances(json.instances);
    }
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.processId != null) {
      builder.processId(json.processId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ScaleProcessRequest ScaleProcessRequest}.
   * <pre>
   * ScaleProcessRequest.builder()
   *    .diskInMb(Integer | null) // nullable {@link ScaleProcessRequest#getDiskInMb() diskInMb}
   *    .instances(Integer | null) // nullable {@link ScaleProcessRequest#getInstances() instances}
   *    .memoryInMb(Integer | null) // nullable {@link ScaleProcessRequest#getMemoryInMb() memoryInMb}
   *    .processId(String) // required {@link ScaleProcessRequest#getProcessId() processId}
   *    .build();
   * </pre>
   * @return A new ScaleProcessRequest builder
   */
  public static ScaleProcessRequest.Builder builder() {
    return new ScaleProcessRequest.Builder();
  }

  /**
   * Builds instances of type {@link ScaleProcessRequest ScaleProcessRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ScaleProcessRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PROCESS_ID = 0x1L;
    private long initBits = 0x1L;

    private Integer diskInMb;
    private Integer instances;
    private Integer memoryInMb;
    private String processId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ScaleProcessRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ScaleProcessRequest instance) {
      return from((_ScaleProcessRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ScaleProcessRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ScaleProcessRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer diskInMbValue = instance.getDiskInMb();
      if (diskInMbValue != null) {
        diskInMb(diskInMbValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryInMbValue = instance.getMemoryInMb();
      if (memoryInMbValue != null) {
        memoryInMb(memoryInMbValue);
      }
      processId(instance.getProcessId());
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleProcessRequest#getDiskInMb() diskInMb} attribute.
     * @param diskInMb The value for diskInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleProcessRequest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleProcessRequest#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleProcessRequest#getProcessId() processId} attribute.
     * @param processId The value for processId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String processId) {
      this.processId = Objects.requireNonNull(processId, "processId");
      initBits &= ~INIT_BIT_PROCESS_ID;
      return this;
    }

    /**
     * Builds a new {@link ScaleProcessRequest ScaleProcessRequest}.
     * @return An immutable instance of ScaleProcessRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ScaleProcessRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ScaleProcessRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROCESS_ID) != 0) attributes.add("processId");
      return "Cannot build ScaleProcessRequest, some of required attributes are not set " + attributes;
    }
  }
}
