package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Process operation
 */
@Generated(from = "_UpdateProcessRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateProcessRequest extends org.cloudfoundry.client.v3.processes._UpdateProcessRequest {
  private final @Nullable String command;
  private final @Nullable HealthCheck healthCheck;
  private final String processId;

  private UpdateProcessRequest(UpdateProcessRequest.Builder builder) {
    this.command = builder.command;
    this.healthCheck = builder.healthCheck;
    this.processId = builder.processId;
  }

  /**
   * The command
   */
  @JsonProperty("command")
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The health check
   */
  @JsonProperty("health_check")
  @Override
  public @Nullable HealthCheck getHealthCheck() {
    return healthCheck;
  }

  /**
   * The process id
   */
  @JsonProperty("processId")
  @JsonIgnore
  @Override
  public String getProcessId() {
    return processId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateProcessRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateProcessRequest
        && equalTo(0, (UpdateProcessRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateProcessRequest another) {
    return Objects.equals(command, another.command)
        && Objects.equals(healthCheck, another.healthCheck)
        && processId.equals(another.processId);
  }

  /**
   * Computes a hash code from attributes: {@code command}, {@code healthCheck}, {@code processId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(healthCheck);
    h += (h << 5) + processId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateProcessRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateProcessRequest{"
        + "command=" + command
        + ", healthCheck=" + healthCheck
        + ", processId=" + processId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateProcessRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._UpdateProcessRequest {
    String command;
    HealthCheck healthCheck;
    String processId;
    @JsonProperty("command")
    public void setCommand(@Nullable String command) {
      this.command = command;
    }
    @JsonProperty("health_check")
    public void setHealthCheck(@Nullable HealthCheck healthCheck) {
      this.healthCheck = healthCheck;
    }
    @JsonProperty("processId")
    @JsonIgnore
    public void setProcessId(String processId) {
      this.processId = processId;
    }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public HealthCheck getHealthCheck() { throw new UnsupportedOperationException(); }
    @Override
    public String getProcessId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateProcessRequest fromJson(Json json) {
    UpdateProcessRequest.Builder builder = UpdateProcessRequest.builder();
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.healthCheck != null) {
      builder.healthCheck(json.healthCheck);
    }
    if (json.processId != null) {
      builder.processId(json.processId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateProcessRequest UpdateProcessRequest}.
   * <pre>
   * UpdateProcessRequest.builder()
   *    .command(String | null) // nullable {@link UpdateProcessRequest#getCommand() command}
   *    .healthCheck(org.cloudfoundry.client.v3.processes.HealthCheck | null) // nullable {@link UpdateProcessRequest#getHealthCheck() healthCheck}
   *    .processId(String) // required {@link UpdateProcessRequest#getProcessId() processId}
   *    .build();
   * </pre>
   * @return A new UpdateProcessRequest builder
   */
  public static UpdateProcessRequest.Builder builder() {
    return new UpdateProcessRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateProcessRequest UpdateProcessRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateProcessRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PROCESS_ID = 0x1L;
    private long initBits = 0x1L;

    private String command;
    private HealthCheck healthCheck;
    private String processId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateProcessRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateProcessRequest instance) {
      return from((_UpdateProcessRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateProcessRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateProcessRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      HealthCheck healthCheckValue = instance.getHealthCheck();
      if (healthCheckValue != null) {
        healthCheck(healthCheckValue);
      }
      processId(instance.getProcessId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateProcessRequest#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateProcessRequest#getHealthCheck() healthCheck} attribute.
     * @param healthCheck The value for healthCheck (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheck(@Nullable HealthCheck healthCheck) {
      this.healthCheck = healthCheck;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateProcessRequest#getProcessId() processId} attribute.
     * @param processId The value for processId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String processId) {
      this.processId = Objects.requireNonNull(processId, "processId");
      initBits &= ~INIT_BIT_PROCESS_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateProcessRequest UpdateProcessRequest}.
     * @return An immutable instance of UpdateProcessRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateProcessRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateProcessRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROCESS_ID) != 0) attributes.add("processId");
      return "Cannot build UpdateProcessRequest, some of required attributes are not set " + attributes;
    }
  }
}
