package org.cloudfoundry.client.v3.roles;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The Role relationships
 */
@Generated(from = "_RoleRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RoleRelationships extends org.cloudfoundry.client.v3.roles._RoleRelationships {
  private final @Nullable ToOneRelationship organization;
  private final @Nullable ToOneRelationship space;
  private final ToOneRelationship user;

  private RoleRelationships(RoleRelationships.Builder builder) {
    this.organization = builder.organization;
    this.space = builder.space;
    this.user = builder.user;
  }

  /**
   * The organization relationship
   */
  @JsonProperty("organization")
  @Override
  public @Nullable ToOneRelationship getOrganization() {
    return organization;
  }

  /**
   * The space relationship
   */
  @JsonProperty("space")
  @Override
  public @Nullable ToOneRelationship getSpace() {
    return space;
  }

  /**
   * The user relationship
   */
  @JsonProperty("user")
  @Override
  public ToOneRelationship getUser() {
    return user;
  }

  /**
   * This instance is equal to all instances of {@code RoleRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RoleRelationships
        && equalTo(0, (RoleRelationships) another);
  }

  private boolean equalTo(int synthetic, RoleRelationships another) {
    return Objects.equals(organization, another.organization)
        && Objects.equals(space, another.space)
        && user.equals(another.user);
  }

  /**
   * Computes a hash code from attributes: {@code organization}, {@code space}, {@code user}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(organization);
    h += (h << 5) + Objects.hashCode(space);
    h += (h << 5) + user.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RoleRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RoleRelationships{"
        + "organization=" + organization
        + ", space=" + space
        + ", user=" + user
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_RoleRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.roles._RoleRelationships {
    ToOneRelationship organization;
    ToOneRelationship space;
    ToOneRelationship user;
    @JsonProperty("organization")
    public void setOrganization(@Nullable ToOneRelationship organization) {
      this.organization = organization;
    }
    @JsonProperty("space")
    public void setSpace(@Nullable ToOneRelationship space) {
      this.space = space;
    }
    @JsonProperty("user")
    public void setUser(ToOneRelationship user) {
      this.user = user;
    }
    @Override
    public ToOneRelationship getOrganization() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getSpace() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getUser() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RoleRelationships fromJson(Json json) {
    RoleRelationships.Builder builder = RoleRelationships.builder();
    if (json.organization != null) {
      builder.organization(json.organization);
    }
    if (json.space != null) {
      builder.space(json.space);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RoleRelationships RoleRelationships}.
   * <pre>
   * RoleRelationships.builder()
   *    .organization(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link RoleRelationships#getOrganization() organization}
   *    .space(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link RoleRelationships#getSpace() space}
   *    .user(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link RoleRelationships#getUser() user}
   *    .build();
   * </pre>
   * @return A new RoleRelationships builder
   */
  public static RoleRelationships.Builder builder() {
    return new RoleRelationships.Builder();
  }

  /**
   * Builds instances of type {@link RoleRelationships RoleRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RoleRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_USER = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship organization;
    private ToOneRelationship space;
    private ToOneRelationship user;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RoleRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RoleRelationships instance) {
      return from((_RoleRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _RoleRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RoleRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      ToOneRelationship organizationValue = instance.getOrganization();
      if (organizationValue != null) {
        organization(organizationValue);
      }
      ToOneRelationship spaceValue = instance.getSpace();
      if (spaceValue != null) {
        space(spaceValue);
      }
      user(instance.getUser());
      return this;
    }

    /**
     * Initializes the value for the {@link RoleRelationships#getOrganization() organization} attribute.
     * @param organization The value for organization (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization")
    public final Builder organization(@Nullable ToOneRelationship organization) {
      this.organization = organization;
      return this;
    }

    /**
     * Initializes the value for the {@link RoleRelationships#getSpace() space} attribute.
     * @param space The value for space (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space")
    public final Builder space(@Nullable ToOneRelationship space) {
      this.space = space;
      return this;
    }

    /**
     * Initializes the value for the {@link RoleRelationships#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("user")
    public final Builder user(ToOneRelationship user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Builds a new {@link RoleRelationships RoleRelationships}.
     * @return An immutable instance of RoleRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RoleRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RoleRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER) != 0) attributes.add("user");
      return "Cannot build RoleRelationships, some of required attributes are not set " + attributes;
    }
  }
}
