package org.cloudfoundry.client.v3.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Route Destinations operation
 */
@Generated(from = "_ListRouteDestinationsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListRouteDestinationsRequest
    extends org.cloudfoundry.client.v3.routes._ListRouteDestinationsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> applicationIds;
  private final List<String> destinationIds;
  private final String routeId;

  private ListRouteDestinationsRequest(ListRouteDestinationsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.destinationIds = createUnmodifiableList(true, builder.destinationIds);
    this.routeId = builder.routeId;
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The application ids filter
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The destination ids filter
   */
  @Override
  public List<String> getDestinationIds() {
    return destinationIds;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code ListRouteDestinationsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRouteDestinationsRequest
        && equalTo(0, (ListRouteDestinationsRequest) another);
  }

  private boolean equalTo(int synthetic, ListRouteDestinationsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationIds.equals(another.applicationIds)
        && destinationIds.equals(another.destinationIds)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationIds}, {@code destinationIds}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + destinationIds.hashCode();
    h += (h << 5) + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListRouteDestinationsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRouteDestinationsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationIds=" + applicationIds
        + ", destinationIds=" + destinationIds
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Creates a builder for {@link ListRouteDestinationsRequest ListRouteDestinationsRequest}.
   * <pre>
   * ListRouteDestinationsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListRouteDestinationsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListRouteDestinationsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListRouteDestinationsRequest#getPerPage() perPage}
   *    .applicationId|addAllApplicationIds(String) // {@link ListRouteDestinationsRequest#getApplicationIds() applicationIds} elements
   *    .destinationId|addAllDestinationIds(String) // {@link ListRouteDestinationsRequest#getDestinationIds() destinationIds} elements
   *    .routeId(String) // required {@link ListRouteDestinationsRequest#getRouteId() routeId}
   *    .build();
   * </pre>
   * @return A new ListRouteDestinationsRequest builder
   */
  public static ListRouteDestinationsRequest.Builder builder() {
    return new ListRouteDestinationsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListRouteDestinationsRequest ListRouteDestinationsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListRouteDestinationsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private long initBits = 0x1L;

    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> destinationIds = new ArrayList<String>();
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRouteDestinationsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRouteDestinationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListRouteDestinationsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListRouteDestinationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.routes._ListRouteDestinationsRequest) {
        org.cloudfoundry.client.v3.routes._ListRouteDestinationsRequest instance = (org.cloudfoundry.client.v3.routes._ListRouteDestinationsRequest) object;
        addAllDestinationIds(instance.getDestinationIds());
        addAllApplicationIds(instance.getApplicationIds());
        routeId(instance.getRouteId());
      }
    }

    /**
     * Initializes the value for the {@link ListRouteDestinationsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRouteDestinationsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRouteDestinationsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListRouteDestinationsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRouteDestinationsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRouteDestinationsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListRouteDestinationsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRouteDestinationsRequest#getDestinationIds() destinationIds} list.
     * @param element A destinationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destinationId(String element) {
      this.destinationIds.add(Objects.requireNonNull(element, "destinationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRouteDestinationsRequest#getDestinationIds() destinationIds} list.
     * @param elements An array of destinationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destinationIds(String... elements) {
      for (String element : elements) {
        this.destinationIds.add(Objects.requireNonNull(element, "destinationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRouteDestinationsRequest#getDestinationIds() destinationIds} list.
     * @param elements An iterable of destinationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destinationIds(Iterable<String> elements) {
      this.destinationIds.clear();
      return addAllDestinationIds(elements);
    }

    /**
     * Adds elements to {@link ListRouteDestinationsRequest#getDestinationIds() destinationIds} list.
     * @param elements An iterable of destinationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDestinationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.destinationIds.add(Objects.requireNonNull(element, "destinationIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListRouteDestinationsRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link ListRouteDestinationsRequest ListRouteDestinationsRequest}.
     * @return An immutable instance of ListRouteDestinationsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRouteDestinationsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListRouteDestinationsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build ListRouteDestinationsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
