package org.cloudfoundry.client.v3.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Routes operation
 */
@Generated(from = "_ListRoutesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListRoutesRequest extends org.cloudfoundry.client.v3.routes._ListRoutesRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> applicationIds;
  private final List<String> domainIds;
  private final List<String> hosts;
  private final @Nullable String labelSelector;
  private final List<String> organizationIds;
  private final List<String> paths;
  private final List<Integer> ports;
  private final List<String> spaceIds;

  private ListRoutesRequest(ListRoutesRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.domainIds = createUnmodifiableList(true, builder.domainIds);
    this.hosts = createUnmodifiableList(true, builder.hosts);
    this.labelSelector = builder.labelSelector;
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.paths = createUnmodifiableList(true, builder.paths);
    this.ports = createUnmodifiableList(true, builder.ports);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The application ids filter
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The domain ids filter
   */
  @Override
  public List<String> getDomainIds() {
    return domainIds;
  }

  /**
   * The hosts filter
   */
  @Override
  public List<String> getHosts() {
    return hosts;
  }

  /**
   * A query string containing a list of label selector requirements
   */
  @Override
  public @Nullable String getLabelSelector() {
    return labelSelector;
  }

  /**
   * The organization ids filter
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The paths filter
   */
  @Override
  public List<String> getPaths() {
    return paths;
  }

  /**
   * The ports filter
   */
  @Override
  public List<Integer> getPorts() {
    return ports;
  }

  /**
   * The space ids filter
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * This instance is equal to all instances of {@code ListRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRoutesRequest
        && equalTo(0, (ListRoutesRequest) another);
  }

  private boolean equalTo(int synthetic, ListRoutesRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationIds.equals(another.applicationIds)
        && domainIds.equals(another.domainIds)
        && hosts.equals(another.hosts)
        && Objects.equals(labelSelector, another.labelSelector)
        && organizationIds.equals(another.organizationIds)
        && paths.equals(another.paths)
        && ports.equals(another.ports)
        && spaceIds.equals(another.spaceIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationIds}, {@code domainIds}, {@code hosts}, {@code labelSelector}, {@code organizationIds}, {@code paths}, {@code ports}, {@code spaceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + domainIds.hashCode();
    h += (h << 5) + hosts.hashCode();
    h += (h << 5) + Objects.hashCode(labelSelector);
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + paths.hashCode();
    h += (h << 5) + ports.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRoutesRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationIds=" + applicationIds
        + ", domainIds=" + domainIds
        + ", hosts=" + hosts
        + ", labelSelector=" + labelSelector
        + ", organizationIds=" + organizationIds
        + ", paths=" + paths
        + ", ports=" + ports
        + ", spaceIds=" + spaceIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListRoutesRequest ListRoutesRequest}.
   * <pre>
   * ListRoutesRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListRoutesRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListRoutesRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListRoutesRequest#getPerPage() perPage}
   *    .applicationId|addAllApplicationIds(String) // {@link ListRoutesRequest#getApplicationIds() applicationIds} elements
   *    .domainId|addAllDomainIds(String) // {@link ListRoutesRequest#getDomainIds() domainIds} elements
   *    .host|addAllHosts(String) // {@link ListRoutesRequest#getHosts() hosts} elements
   *    .labelSelector(String | null) // nullable {@link ListRoutesRequest#getLabelSelector() labelSelector}
   *    .organizationId|addAllOrganizationIds(String) // {@link ListRoutesRequest#getOrganizationIds() organizationIds} elements
   *    .path|addAllPaths(String) // {@link ListRoutesRequest#getPaths() paths} elements
   *    .port|addAllPorts(int) // {@link ListRoutesRequest#getPorts() ports} elements
   *    .spaceId|addAllSpaceIds(String) // {@link ListRoutesRequest#getSpaceIds() spaceIds} elements
   *    .build();
   * </pre>
   * @return A new ListRoutesRequest builder
   */
  public static ListRoutesRequest.Builder builder() {
    return new ListRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListRoutesRequest ListRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListRoutesRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> domainIds = new ArrayList<String>();
    private List<String> hosts = new ArrayList<String>();
    private String labelSelector;
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> paths = new ArrayList<String>();
    private List<Integer> ports = new ArrayList<Integer>();
    private List<String> spaceIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRoutesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.routes._ListRoutesRequest) {
        org.cloudfoundry.client.v3.routes._ListRoutesRequest instance = (org.cloudfoundry.client.v3.routes._ListRoutesRequest) object;
        addAllDomainIds(instance.getDomainIds());
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllHosts(instance.getHosts());
        addAllPaths(instance.getPaths());
        String labelSelectorValue = instance.getLabelSelector();
        if (labelSelectorValue != null) {
          labelSelector(labelSelectorValue);
        }
        addAllSpaceIds(instance.getSpaceIds());
        addAllPorts(instance.getPorts());
        addAllApplicationIds(instance.getApplicationIds());
      }
    }

    /**
     * Initializes the value for the {@link ListRoutesRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRoutesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRoutesRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListRoutesRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRoutesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRoutesRequest#getDomainIds() domainIds} list.
     * @param element A domainIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An array of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(String... elements) {
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(Iterable<String> elements) {
      this.domainIds.clear();
      return addAllDomainIds(elements);
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainIds(Iterable<String> elements) {
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRoutesRequest#getHosts() hosts} list.
     * @param element A hosts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String element) {
      this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getHosts() hosts} list.
     * @param elements An array of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(String... elements) {
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRoutesRequest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(Iterable<String> elements) {
      this.hosts.clear();
      return addAllHosts(elements);
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllHosts(Iterable<String> elements) {
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListRoutesRequest#getLabelSelector() labelSelector} attribute.
     * @param labelSelector The value for labelSelector (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(@Nullable String labelSelector) {
      this.labelSelector = labelSelector;
      return this;
    }

    /**
     * Adds one element to {@link ListRoutesRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRoutesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRoutesRequest#getPaths() paths} list.
     * @param element A paths element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(String element) {
      this.paths.add(Objects.requireNonNull(element, "paths element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getPaths() paths} list.
     * @param elements An array of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paths(String... elements) {
      for (String element : elements) {
        this.paths.add(Objects.requireNonNull(element, "paths element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRoutesRequest#getPaths() paths} list.
     * @param elements An iterable of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paths(Iterable<String> elements) {
      this.paths.clear();
      return addAllPaths(elements);
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getPaths() paths} list.
     * @param elements An iterable of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPaths(Iterable<String> elements) {
      for (String element : elements) {
        this.paths.add(Objects.requireNonNull(element, "paths element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRoutesRequest#getPorts() ports} list.
     * @param element A ports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int element) {
      this.ports.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getPorts() ports} list.
     * @param elements An array of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(int... elements) {
      for (int element : elements) {
        this.ports.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRoutesRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(Iterable<Integer> elements) {
      this.ports.clear();
      return addAllPorts(elements);
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPorts(Iterable<Integer> elements) {
      for (Integer element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRoutesRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRoutesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListRoutesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListRoutesRequest ListRoutesRequest}.
     * @return An immutable instance of ListRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRoutesRequest build() {
      return new ListRoutesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
