package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Route operation
 */
@Generated(from = "_UpdateRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateRouteRequest extends org.cloudfoundry.client.v3.routes._UpdateRouteRequest {
  private final @Nullable Metadata metadata;
  private final String routeId;

  private UpdateRouteRequest(UpdateRouteRequest.Builder builder) {
    this.metadata = builder.metadata;
    this.routeId = builder.routeId;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The route id
   */
  @JsonProperty("routeId")
  @JsonIgnore
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateRouteRequest
        && equalTo(0, (UpdateRouteRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateRouteRequest another) {
    return Objects.equals(metadata, another.metadata)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateRouteRequest{"
        + "metadata=" + metadata
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateRouteRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._UpdateRouteRequest {
    Metadata metadata;
    String routeId;
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("routeId")
    @JsonIgnore
    public void setRouteId(String routeId) {
      this.routeId = routeId;
    }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateRouteRequest fromJson(Json json) {
    UpdateRouteRequest.Builder builder = UpdateRouteRequest.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.routeId != null) {
      builder.routeId(json.routeId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateRouteRequest UpdateRouteRequest}.
   * <pre>
   * UpdateRouteRequest.builder()
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateRouteRequest#getMetadata() metadata}
   *    .routeId(String) // required {@link UpdateRouteRequest#getRouteId() routeId}
   *    .build();
   * </pre>
   * @return A new UpdateRouteRequest builder
   */
  public static UpdateRouteRequest.Builder builder() {
    return new UpdateRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateRouteRequest UpdateRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private long initBits = 0x1L;

    private Metadata metadata;
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateRouteRequest instance) {
      return from((_UpdateRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      routeId(instance.getRouteId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouteRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateRouteRequest UpdateRouteRequest}.
     * @return An immutable instance of UpdateRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build UpdateRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
