package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _BindStagingSecurityGroupResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BindStagingSecurityGroupResponse.builder()}.
 */
@Generated(from = "_BindStagingSecurityGroupResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BindStagingSecurityGroupResponse
    extends org.cloudfoundry.client.v3.securitygroups._BindStagingSecurityGroupResponse {
  private final List<Relationship> boundSpaces;
  private final Map<String, Link> links;

  private BindStagingSecurityGroupResponse(BindStagingSecurityGroupResponse.Builder builder) {
    this.boundSpaces = createUnmodifiableList(true, builder.boundSpaces);
    this.links = createUnmodifiableMap(false, false, builder.links);
  }

  /**
   * A relationship to the spaces where the security_group is applied to applications during
   * runtime
   */
  @JsonProperty("data")
  @Override
  public List<Relationship> getBoundSpaces() {
    return boundSpaces;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * This instance is equal to all instances of {@code BindStagingSecurityGroupResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BindStagingSecurityGroupResponse
        && equalTo(0, (BindStagingSecurityGroupResponse) another);
  }

  private boolean equalTo(int synthetic, BindStagingSecurityGroupResponse another) {
    return boundSpaces.equals(another.boundSpaces)
        && links.equals(another.links);
  }

  /**
   * Computes a hash code from attributes: {@code boundSpaces}, {@code links}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + boundSpaces.hashCode();
    h += (h << 5) + links.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BindStagingSecurityGroupResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BindStagingSecurityGroupResponse{"
        + "boundSpaces=" + boundSpaces
        + ", links=" + links
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BindStagingSecurityGroupResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._BindStagingSecurityGroupResponse {
    List<Relationship> boundSpaces = Collections.emptyList();
    Map<String, Link> links = Collections.emptyMap();
    @JsonProperty("data")
    public void setBoundSpaces(List<Relationship> boundSpaces) {
      this.boundSpaces = boundSpaces;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @Override
    public List<Relationship> getBoundSpaces() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BindStagingSecurityGroupResponse fromJson(Json json) {
    BindStagingSecurityGroupResponse.Builder builder = BindStagingSecurityGroupResponse.builder();
    if (json.boundSpaces != null) {
      builder.addAllBoundSpaces(json.boundSpaces);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BindStagingSecurityGroupResponse BindStagingSecurityGroupResponse}.
   * <pre>
   * BindStagingSecurityGroupResponse.builder()
   *    .boundSpace|addAllBoundSpaces(org.cloudfoundry.client.v3.Relationship) // {@link _BindStagingSecurityGroupResponse#getBoundSpaces() boundSpaces} elements
   *    .link|putAllLinks(String =&gt; org.cloudfoundry.client.v3.Link) // {@link _BindStagingSecurityGroupResponse#getLinks() links} mappings
   *    .build();
   * </pre>
   * @return A new BindStagingSecurityGroupResponse builder
   */
  public static BindStagingSecurityGroupResponse.Builder builder() {
    return new BindStagingSecurityGroupResponse.Builder();
  }

  /**
   * Builds instances of type {@link BindStagingSecurityGroupResponse BindStagingSecurityGroupResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BindStagingSecurityGroupResponse", generator = "Immutables")
  public static final class Builder {
    private List<Relationship> boundSpaces = new ArrayList<Relationship>();
    private Map<String, Link> links = new LinkedHashMap<String, Link>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.securitygroups.AbstractBindSecurityGroupResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractBindSecurityGroupResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.securitygroups._BindStagingSecurityGroupResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(org.cloudfoundry.client.v3.securitygroups._BindStagingSecurityGroupResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractBindSecurityGroupResponse) {
        AbstractBindSecurityGroupResponse instance = (AbstractBindSecurityGroupResponse) object;
        putAllLinks(instance.getLinks());
        addAllBoundSpaces(instance.getBoundSpaces());
      }
    }

    /**
     * Adds one element to {@link _BindStagingSecurityGroupResponse#getBoundSpaces() boundSpaces} list.
     * @param element A boundSpaces element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder boundSpace(Relationship element) {
      this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
      return this;
    }

    /**
     * Adds elements to {@link _BindStagingSecurityGroupResponse#getBoundSpaces() boundSpaces} list.
     * @param elements An array of boundSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder boundSpaces(Relationship... elements) {
      for (Relationship element : elements) {
        this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link _BindStagingSecurityGroupResponse#getBoundSpaces() boundSpaces} list.
     * @param elements An iterable of boundSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder boundSpaces(Iterable<? extends Relationship> elements) {
      this.boundSpaces.clear();
      return addAllBoundSpaces(elements);
    }

    /**
     * Adds elements to {@link _BindStagingSecurityGroupResponse#getBoundSpaces() boundSpaces} list.
     * @param elements An iterable of boundSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBoundSpaces(Iterable<? extends Relationship> elements) {
      for (Relationship element : elements) {
        this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _BindStagingSecurityGroupResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _BindStagingSecurityGroupResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _BindStagingSecurityGroupResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _BindStagingSecurityGroupResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link BindStagingSecurityGroupResponse BindStagingSecurityGroupResponse}.
     * @return An immutable instance of BindStagingSecurityGroupResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BindStagingSecurityGroupResponse build() {
      return new BindStagingSecurityGroupResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
