package org.cloudfoundry.client.v3.securitygroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Security Group operation
 */
@Generated(from = "_DeleteSecurityGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteSecurityGroupRequest
    extends org.cloudfoundry.client.v3.securitygroups._DeleteSecurityGroupRequest {
  private final String securityGroupId;

  private DeleteSecurityGroupRequest(DeleteSecurityGroupRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
  }

  /**
   * The Security Group id
   */
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteSecurityGroupRequest
        && equalTo(0, (DeleteSecurityGroupRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteSecurityGroupRequest another) {
    return securityGroupId.equals(another.securityGroupId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + securityGroupId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteSecurityGroupRequest{"
        + "securityGroupId=" + securityGroupId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteSecurityGroupRequest DeleteSecurityGroupRequest}.
   * <pre>
   * DeleteSecurityGroupRequest.builder()
   *    .securityGroupId(String) // required {@link DeleteSecurityGroupRequest#getSecurityGroupId() securityGroupId}
   *    .build();
   * </pre>
   * @return A new DeleteSecurityGroupRequest builder
   */
  public static DeleteSecurityGroupRequest.Builder builder() {
    return new DeleteSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteSecurityGroupRequest DeleteSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteSecurityGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private String securityGroupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteSecurityGroupRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteSecurityGroupRequest instance) {
      return from((_DeleteSecurityGroupRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupId(instance.getSecurityGroupId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteSecurityGroupRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteSecurityGroupRequest DeleteSecurityGroupRequest}.
     * @return An immutable instance of DeleteSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      return "Cannot build DeleteSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }
}
