package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Security Group operation
 */
@Generated(from = "_GetSecurityGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetSecurityGroupRequest
    extends org.cloudfoundry.client.v3.securitygroups._GetSecurityGroupRequest {
  private final String securityGroupId;

  private GetSecurityGroupRequest(GetSecurityGroupRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
  }

  /**
   * The Security Group id
   */
  @JsonProperty("securityGroupId")
  @JsonIgnore
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * This instance is equal to all instances of {@code GetSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSecurityGroupRequest
        && equalTo(0, (GetSecurityGroupRequest) another);
  }

  private boolean equalTo(int synthetic, GetSecurityGroupRequest another) {
    return securityGroupId.equals(another.securityGroupId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + securityGroupId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSecurityGroupRequest{"
        + "securityGroupId=" + securityGroupId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetSecurityGroupRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._GetSecurityGroupRequest {
    String securityGroupId;
    @JsonProperty("securityGroupId")
    @JsonIgnore
    public void setSecurityGroupId(String securityGroupId) {
      this.securityGroupId = securityGroupId;
    }
    @Override
    public String getSecurityGroupId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetSecurityGroupRequest fromJson(Json json) {
    GetSecurityGroupRequest.Builder builder = GetSecurityGroupRequest.builder();
    if (json.securityGroupId != null) {
      builder.securityGroupId(json.securityGroupId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetSecurityGroupRequest GetSecurityGroupRequest}.
   * <pre>
   * GetSecurityGroupRequest.builder()
   *    .securityGroupId(String) // required {@link GetSecurityGroupRequest#getSecurityGroupId() securityGroupId}
   *    .build();
   * </pre>
   * @return A new GetSecurityGroupRequest builder
   */
  public static GetSecurityGroupRequest.Builder builder() {
    return new GetSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetSecurityGroupRequest GetSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetSecurityGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private String securityGroupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSecurityGroupRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSecurityGroupRequest instance) {
      return from((_GetSecurityGroupRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupId(instance.getSecurityGroupId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetSecurityGroupRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Builds a new {@link GetSecurityGroupRequest GetSecurityGroupRequest}.
     * @return An immutable instance of GetSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      return "Cannot build GetSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }
}
