package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.ToManyRelationship;
import org.immutables.value.Generated;

/**
 * Holds relationships to running/staging spaces where security groups is
 * applied
 */
@Generated(from = "_Relationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Relationships extends org.cloudfoundry.client.v3.securitygroups._Relationships {
  private final ToManyRelationship runningSpaces;
  private final ToManyRelationship stagingSpaces;

  private Relationships(Relationships.Builder builder) {
    this.runningSpaces = builder.runningSpaces;
    this.stagingSpaces = builder.stagingSpaces;
  }

  /**
   * A relationship to the spaces where the security_group is applied to
   * applications during runtime
   */
  @JsonProperty("running_spaces")
  @Override
  public ToManyRelationship getRunningSpaces() {
    return runningSpaces;
  }

  /**
   * A relationship to the spaces where the security_group is applied to
   * applications during runtime
   */
  @JsonProperty("staging_spaces")
  @Override
  public ToManyRelationship getStagingSpaces() {
    return stagingSpaces;
  }

  /**
   * This instance is equal to all instances of {@code Relationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Relationships
        && equalTo(0, (Relationships) another);
  }

  private boolean equalTo(int synthetic, Relationships another) {
    return runningSpaces.equals(another.runningSpaces)
        && stagingSpaces.equals(another.stagingSpaces);
  }

  /**
   * Computes a hash code from attributes: {@code runningSpaces}, {@code stagingSpaces}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + runningSpaces.hashCode();
    h += (h << 5) + stagingSpaces.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Relationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Relationships{"
        + "runningSpaces=" + runningSpaces
        + ", stagingSpaces=" + stagingSpaces
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Relationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._Relationships {
    ToManyRelationship runningSpaces;
    ToManyRelationship stagingSpaces;
    @JsonProperty("running_spaces")
    public void setRunningSpaces(ToManyRelationship runningSpaces) {
      this.runningSpaces = runningSpaces;
    }
    @JsonProperty("staging_spaces")
    public void setStagingSpaces(ToManyRelationship stagingSpaces) {
      this.stagingSpaces = stagingSpaces;
    }
    @Override
    public ToManyRelationship getRunningSpaces() { throw new UnsupportedOperationException(); }
    @Override
    public ToManyRelationship getStagingSpaces() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Relationships fromJson(Json json) {
    Relationships.Builder builder = Relationships.builder();
    if (json.runningSpaces != null) {
      builder.runningSpaces(json.runningSpaces);
    }
    if (json.stagingSpaces != null) {
      builder.stagingSpaces(json.stagingSpaces);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Relationships Relationships}.
   * <pre>
   * Relationships.builder()
   *    .runningSpaces(org.cloudfoundry.client.v3.ToManyRelationship) // required {@link Relationships#getRunningSpaces() runningSpaces}
   *    .stagingSpaces(org.cloudfoundry.client.v3.ToManyRelationship) // required {@link Relationships#getStagingSpaces() stagingSpaces}
   *    .build();
   * </pre>
   * @return A new Relationships builder
   */
  public static Relationships.Builder builder() {
    return new Relationships.Builder();
  }

  /**
   * Builds instances of type {@link Relationships Relationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Relationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_RUNNING_SPACES = 0x1L;
    private static final long INIT_BIT_STAGING_SPACES = 0x2L;
    private long initBits = 0x3L;

    private ToManyRelationship runningSpaces;
    private ToManyRelationship stagingSpaces;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Relationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Relationships instance) {
      return from((_Relationships) instance);
    }

    /**
     * Copy abstract value type {@code _Relationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Relationships instance) {
      Objects.requireNonNull(instance, "instance");
      runningSpaces(instance.getRunningSpaces());
      stagingSpaces(instance.getStagingSpaces());
      return this;
    }

    /**
     * Initializes the value for the {@link Relationships#getRunningSpaces() runningSpaces} attribute.
     * @param runningSpaces The value for runningSpaces 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("running_spaces")
    public final Builder runningSpaces(ToManyRelationship runningSpaces) {
      this.runningSpaces = Objects.requireNonNull(runningSpaces, "runningSpaces");
      initBits &= ~INIT_BIT_RUNNING_SPACES;
      return this;
    }

    /**
     * Initializes the value for the {@link Relationships#getStagingSpaces() stagingSpaces} attribute.
     * @param stagingSpaces The value for stagingSpaces 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_spaces")
    public final Builder stagingSpaces(ToManyRelationship stagingSpaces) {
      this.stagingSpaces = Objects.requireNonNull(stagingSpaces, "stagingSpaces");
      initBits &= ~INIT_BIT_STAGING_SPACES;
      return this;
    }

    /**
     * Builds a new {@link Relationships Relationships}.
     * @return An immutable instance of Relationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Relationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Relationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RUNNING_SPACES) != 0) attributes.add("runningSpaces");
      if ((initBits & INIT_BIT_STAGING_SPACES) != 0) attributes.add("stagingSpaces");
      return "Cannot build Relationships, some of required attributes are not set " + attributes;
    }
  }
}
