package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * A security group rule
 */
@Generated(from = "_Rule", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Rule extends org.cloudfoundry.client.v3.securitygroups._Rule {
  private final @Nullable Integer code;
  private final @Nullable String description;
  private final @Nullable String destination;
  private final @Nullable Boolean log;
  private final @Nullable String ports;
  private final @Nullable Protocol protocol;
  private final @Nullable Integer type;

  private Rule(Rule.Builder builder) {
    this.code = builder.code;
    this.description = builder.description;
    this.destination = builder.destination;
    this.log = builder.log;
    this.ports = builder.ports;
    this.protocol = builder.protocol;
    this.type = builder.type;
  }

  /**
   * The code control signal for icmp
   */
  @JsonProperty("code")
  @Override
  public @Nullable Integer getCode() {
    return code;
  }

  /**
   * The description of the rule
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The destination
   */
  @JsonProperty("destination")
  @Override
  public @Nullable String getDestination() {
    return destination;
  }

  /**
   * Enables logging for the egress rule
   */
  @JsonProperty("log")
  @Override
  public @Nullable Boolean getLog() {
    return log;
  }

  /**
   * The ports
   */
  @JsonProperty("ports")
  @Override
  public @Nullable String getPorts() {
    return ports;
  }

  /**
   * The protocol
   */
  @JsonProperty("protocol")
  @Override
  public @Nullable Protocol getProtocol() {
    return protocol;
  }

  /**
   * The type control signal for icmp
   */
  @JsonProperty("type")
  @Override
  public @Nullable Integer getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code Rule} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Rule
        && equalTo(0, (Rule) another);
  }

  private boolean equalTo(int synthetic, Rule another) {
    return Objects.equals(code, another.code)
        && Objects.equals(description, another.description)
        && Objects.equals(destination, another.destination)
        && Objects.equals(log, another.log)
        && Objects.equals(ports, another.ports)
        && Objects.equals(protocol, another.protocol)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code description}, {@code destination}, {@code log}, {@code ports}, {@code protocol}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(code);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(destination);
    h += (h << 5) + Objects.hashCode(log);
    h += (h << 5) + Objects.hashCode(ports);
    h += (h << 5) + Objects.hashCode(protocol);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Rule} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Rule{"
        + "code=" + code
        + ", description=" + description
        + ", destination=" + destination
        + ", log=" + log
        + ", ports=" + ports
        + ", protocol=" + protocol
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Rule", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._Rule {
    Integer code;
    String description;
    String destination;
    Boolean log;
    String ports;
    Protocol protocol;
    Integer type;
    @JsonProperty("code")
    public void setCode(@Nullable Integer code) {
      this.code = code;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("destination")
    public void setDestination(@Nullable String destination) {
      this.destination = destination;
    }
    @JsonProperty("log")
    public void setLog(@Nullable Boolean log) {
      this.log = log;
    }
    @JsonProperty("ports")
    public void setPorts(@Nullable String ports) {
      this.ports = ports;
    }
    @JsonProperty("protocol")
    public void setProtocol(@Nullable Protocol protocol) {
      this.protocol = protocol;
    }
    @JsonProperty("type")
    public void setType(@Nullable Integer type) {
      this.type = type;
    }
    @Override
    public Integer getCode() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getDestination() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLog() { throw new UnsupportedOperationException(); }
    @Override
    public String getPorts() { throw new UnsupportedOperationException(); }
    @Override
    public Protocol getProtocol() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Rule fromJson(Json json) {
    Rule.Builder builder = Rule.builder();
    if (json.code != null) {
      builder.code(json.code);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.destination != null) {
      builder.destination(json.destination);
    }
    if (json.log != null) {
      builder.log(json.log);
    }
    if (json.ports != null) {
      builder.ports(json.ports);
    }
    if (json.protocol != null) {
      builder.protocol(json.protocol);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Rule Rule}.
   * <pre>
   * Rule.builder()
   *    .code(Integer | null) // nullable {@link Rule#getCode() code}
   *    .description(String | null) // nullable {@link Rule#getDescription() description}
   *    .destination(String | null) // nullable {@link Rule#getDestination() destination}
   *    .log(Boolean | null) // nullable {@link Rule#getLog() log}
   *    .ports(String | null) // nullable {@link Rule#getPorts() ports}
   *    .protocol(org.cloudfoundry.client.v3.securitygroups.Protocol | null) // nullable {@link Rule#getProtocol() protocol}
   *    .type(Integer | null) // nullable {@link Rule#getType() type}
   *    .build();
   * </pre>
   * @return A new Rule builder
   */
  public static Rule.Builder builder() {
    return new Rule.Builder();
  }

  /**
   * Builds instances of type {@link Rule Rule}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Rule", generator = "Immutables")
  public static final class Builder {
    private Integer code;
    private String description;
    private String destination;
    private Boolean log;
    private String ports;
    private Protocol protocol;
    private Integer type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Rule} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Rule instance) {
      return from((_Rule) instance);
    }

    /**
     * Copy abstract value type {@code _Rule} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Rule instance) {
      Objects.requireNonNull(instance, "instance");
      Integer codeValue = instance.getCode();
      if (codeValue != null) {
        code(codeValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String destinationValue = instance.getDestination();
      if (destinationValue != null) {
        destination(destinationValue);
      }
      Boolean logValue = instance.getLog();
      if (logValue != null) {
        log(logValue);
      }
      String portsValue = instance.getPorts();
      if (portsValue != null) {
        ports(portsValue);
      }
      Protocol protocolValue = instance.getProtocol();
      if (protocolValue != null) {
        protocol(protocolValue);
      }
      Integer typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Rule#getCode() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("code")
    public final Builder code(@Nullable Integer code) {
      this.code = code;
      return this;
    }

    /**
     * Initializes the value for the {@link Rule#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Rule#getDestination() destination} attribute.
     * @param destination The value for destination (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("destination")
    public final Builder destination(@Nullable String destination) {
      this.destination = destination;
      return this;
    }

    /**
     * Initializes the value for the {@link Rule#getLog() log} attribute.
     * @param log The value for log (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("log")
    public final Builder log(@Nullable Boolean log) {
      this.log = log;
      return this;
    }

    /**
     * Initializes the value for the {@link Rule#getPorts() ports} attribute.
     * @param ports The value for ports (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ports")
    public final Builder ports(@Nullable String ports) {
      this.ports = ports;
      return this;
    }

    /**
     * Initializes the value for the {@link Rule#getProtocol() protocol} attribute.
     * @param protocol The value for protocol (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("protocol")
    public final Builder protocol(@Nullable Protocol protocol) {
      this.protocol = protocol;
      return this;
    }

    /**
     * Initializes the value for the {@link Rule#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable Integer type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link Rule Rule}.
     * @return An immutable instance of Rule
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Rule build() {
      return new Rule(this);
    }
  }
}
