package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The Resource response payload for the List SecurityGroups operation
 */
@Generated(from = "_SecurityGroupResource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SecurityGroupResource
    extends org.cloudfoundry.client.v3.securitygroups._SecurityGroupResource {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final String name;
  private final GloballyEnabled globallyEnabled;
  private final List<Rule> rules;
  private final Relationships relationships;

  private SecurityGroupResource(SecurityGroupResource.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.name = builder.name;
    this.globallyEnabled = builder.globallyEnabled;
    this.rules = createUnmodifiableList(true, builder.rules);
    this.relationships = builder.relationships;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The globally enabled
   */
  @JsonProperty("globally_enabled")
  @Override
  public GloballyEnabled getGloballyEnabled() {
    return globallyEnabled;
  }

  /**
   * The rules
   */
  @JsonProperty("rules")
  @Override
  public List<Rule> getRules() {
    return rules;
  }

  /**
   * The space relationships
   */
  @JsonProperty("relationships")
  @Override
  public Relationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code SecurityGroupResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SecurityGroupResource
        && equalTo(0, (SecurityGroupResource) another);
  }

  private boolean equalTo(int synthetic, SecurityGroupResource another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && name.equals(another.name)
        && globallyEnabled.equals(another.globallyEnabled)
        && rules.equals(another.rules)
        && relationships.equals(another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code name}, {@code globallyEnabled}, {@code rules}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + globallyEnabled.hashCode();
    h += (h << 5) + rules.hashCode();
    h += (h << 5) + relationships.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SecurityGroupResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SecurityGroupResource{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", name=" + name
        + ", globallyEnabled=" + globallyEnabled
        + ", rules=" + rules
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_SecurityGroupResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._SecurityGroupResource {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    String name;
    GloballyEnabled globallyEnabled;
    List<Rule> rules = Collections.emptyList();
    Relationships relationships;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("globally_enabled")
    public void setGloballyEnabled(GloballyEnabled globallyEnabled) {
      this.globallyEnabled = globallyEnabled;
    }
    @JsonProperty("rules")
    public void setRules(List<Rule> rules) {
      this.rules = rules;
    }
    @JsonProperty("relationships")
    public void setRelationships(Relationships relationships) {
      this.relationships = relationships;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public GloballyEnabled getGloballyEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public List<Rule> getRules() { throw new UnsupportedOperationException(); }
    @Override
    public Relationships getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SecurityGroupResource fromJson(Json json) {
    SecurityGroupResource.Builder builder = SecurityGroupResource.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.globallyEnabled != null) {
      builder.globallyEnabled(json.globallyEnabled);
    }
    if (json.rules != null) {
      builder.addAllRules(json.rules);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SecurityGroupResource SecurityGroupResource}.
   * <pre>
   * SecurityGroupResource.builder()
   *    .createdAt(String) // required {@link SecurityGroupResource#getCreatedAt() createdAt}
   *    .id(String) // required {@link SecurityGroupResource#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link SecurityGroupResource#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link SecurityGroupResource#getUpdatedAt() updatedAt}
   *    .name(String) // required {@link SecurityGroupResource#getName() name}
   *    .globallyEnabled(org.cloudfoundry.client.v3.securitygroups.GloballyEnabled) // required {@link SecurityGroupResource#getGloballyEnabled() globallyEnabled}
   *    .rule|addAllRules(Rule) // {@link SecurityGroupResource#getRules() rules} elements
   *    .relationships(org.cloudfoundry.client.v3.securitygroups.Relationships) // required {@link SecurityGroupResource#getRelationships() relationships}
   *    .build();
   * </pre>
   * @return A new SecurityGroupResource builder
   */
  public static SecurityGroupResource.Builder builder() {
    return new SecurityGroupResource.Builder();
  }

  /**
   * Builds instances of type {@link SecurityGroupResource SecurityGroupResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SecurityGroupResource", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_GLOBALLY_ENABLED = 0x8L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x10L;
    private long initBits = 0x1fL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private String name;
    private GloballyEnabled globallyEnabled;
    private List<Rule> rules = new ArrayList<Rule>();
    private Relationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.securitygroups.SecurityGroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SecurityGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code SecurityGroupResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SecurityGroupResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _SecurityGroupResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_SecurityGroupResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x2L) == 0) {
          createdAt(instance.getCreatedAt());
          bits |= 0x2L;
        }
        if ((bits & 0x20L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          id(instance.getId());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x80L;
        }
      }
      if (object instanceof SecurityGroup) {
        SecurityGroup instance = (SecurityGroup) object;
        if ((bits & 0x2L) == 0) {
          createdAt(instance.getCreatedAt());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          relationships(instance.getRelationships());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          globallyEnabled(instance.getGloballyEnabled());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          name(instance.getName());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          addAllRules(instance.getRules());
          bits |= 0x1L;
        }
        if ((bits & 0x20L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          id(instance.getId());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x80L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.securitygroups._SecurityGroupResource) {
        org.cloudfoundry.client.v3.securitygroups._SecurityGroupResource instance = (org.cloudfoundry.client.v3.securitygroups._SecurityGroupResource) object;
        if ((bits & 0x10L) == 0) {
          name(instance.getName());
          bits |= 0x10L;
        }
        if ((bits & 0x4L) == 0) {
          relationships(instance.getRelationships());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          addAllRules(instance.getRules());
          bits |= 0x1L;
        }
        if ((bits & 0x8L) == 0) {
          globallyEnabled(instance.getGloballyEnabled());
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the value for the {@link SecurityGroupResource#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupResource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link SecurityGroupResource#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SecurityGroupResource#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SecurityGroupResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SecurityGroupResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupResource#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupResource#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupResource#getGloballyEnabled() globallyEnabled} attribute.
     * @param globallyEnabled The value for globallyEnabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("globally_enabled")
    public final Builder globallyEnabled(GloballyEnabled globallyEnabled) {
      this.globallyEnabled = Objects.requireNonNull(globallyEnabled, "globallyEnabled");
      initBits &= ~INIT_BIT_GLOBALLY_ENABLED;
      return this;
    }

    /**
     * Adds one element to {@link SecurityGroupResource#getRules() rules} list.
     * @param element A rules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(Rule element) {
      this.rules.add(Objects.requireNonNull(element, "rules element"));
      return this;
    }

    /**
     * Adds elements to {@link SecurityGroupResource#getRules() rules} list.
     * @param elements An array of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(Rule... elements) {
      for (Rule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SecurityGroupResource#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rules")
    public final Builder rules(Iterable<? extends Rule> elements) {
      this.rules.clear();
      return addAllRules(elements);
    }

    /**
     * Adds elements to {@link SecurityGroupResource#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRules(Iterable<? extends Rule> elements) {
      for (Rule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupResource#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(Relationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Builds a new {@link SecurityGroupResource SecurityGroupResource}.
     * @return An immutable instance of SecurityGroupResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SecurityGroupResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SecurityGroupResource(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_GLOBALLY_ENABLED) != 0) attributes.add("globallyEnabled");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      return "Cannot build SecurityGroupResource, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
