package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Create a Security Group operation
 */
@Generated(from = "_UpdateSecurityGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateSecurityGroupRequest
    extends org.cloudfoundry.client.v3.securitygroups._UpdateSecurityGroupRequest {
  private final String securityGroupId;
  private final String name;
  private final GloballyEnabled globallyEnabled;
  private final List<Rule> rules;

  private UpdateSecurityGroupRequest(UpdateSecurityGroupRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
    this.name = builder.name;
    this.globallyEnabled = builder.globallyEnabled;
    this.rules = createUnmodifiableList(true, builder.rules);
  }

  /**
   * Id of the security group
   */
  @JsonProperty("securityGroupId")
  @JsonIgnore
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * Name of the security group
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * Object that controls if the group is applied globally to the lifecycle of all applications
   */
  @JsonProperty("globally_enabled")
  @Override
  public GloballyEnabled getGloballyEnabled() {
    return globallyEnabled;
  }

  /**
   * Rules that will be applied by this security group
   */
  @JsonProperty("rules")
  @Override
  public List<Rule> getRules() {
    return rules;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSecurityGroupRequest
        && equalTo(0, (UpdateSecurityGroupRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateSecurityGroupRequest another) {
    return securityGroupId.equals(another.securityGroupId)
        && name.equals(another.name)
        && globallyEnabled.equals(another.globallyEnabled)
        && rules.equals(another.rules);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}, {@code name}, {@code globallyEnabled}, {@code rules}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + securityGroupId.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + globallyEnabled.hashCode();
    h += (h << 5) + rules.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSecurityGroupRequest{"
        + "securityGroupId=" + securityGroupId
        + ", name=" + name
        + ", globallyEnabled=" + globallyEnabled
        + ", rules=" + rules
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateSecurityGroupRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._UpdateSecurityGroupRequest {
    String securityGroupId;
    String name;
    GloballyEnabled globallyEnabled;
    List<Rule> rules = Collections.emptyList();
    @JsonProperty("securityGroupId")
    @JsonIgnore
    public void setSecurityGroupId(String securityGroupId) {
      this.securityGroupId = securityGroupId;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("globally_enabled")
    public void setGloballyEnabled(GloballyEnabled globallyEnabled) {
      this.globallyEnabled = globallyEnabled;
    }
    @JsonProperty("rules")
    public void setRules(List<Rule> rules) {
      this.rules = rules;
    }
    @Override
    public String getSecurityGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public GloballyEnabled getGloballyEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public List<Rule> getRules() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateSecurityGroupRequest fromJson(Json json) {
    UpdateSecurityGroupRequest.Builder builder = UpdateSecurityGroupRequest.builder();
    if (json.securityGroupId != null) {
      builder.securityGroupId(json.securityGroupId);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.globallyEnabled != null) {
      builder.globallyEnabled(json.globallyEnabled);
    }
    if (json.rules != null) {
      builder.addAllRules(json.rules);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
   * <pre>
   * UpdateSecurityGroupRequest.builder()
   *    .securityGroupId(String) // required {@link UpdateSecurityGroupRequest#getSecurityGroupId() securityGroupId}
   *    .name(String) // required {@link UpdateSecurityGroupRequest#getName() name}
   *    .globallyEnabled(org.cloudfoundry.client.v3.securitygroups.GloballyEnabled) // required {@link UpdateSecurityGroupRequest#getGloballyEnabled() globallyEnabled}
   *    .rule|addAllRules(Rule) // {@link UpdateSecurityGroupRequest#getRules() rules} elements
   *    .build();
   * </pre>
   * @return A new UpdateSecurityGroupRequest builder
   */
  public static UpdateSecurityGroupRequest.Builder builder() {
    return new UpdateSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateSecurityGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_GLOBALLY_ENABLED = 0x4L;
    private long initBits = 0x7L;

    private String securityGroupId;
    private String name;
    private GloballyEnabled globallyEnabled;
    private List<Rule> rules = new ArrayList<Rule>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSecurityGroupRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSecurityGroupRequest instance) {
      return from((_UpdateSecurityGroupRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupId(instance.getSecurityGroupId());
      name(instance.getName());
      globallyEnabled(instance.getGloballyEnabled());
      addAllRules(instance.getRules());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSecurityGroupRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSecurityGroupRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSecurityGroupRequest#getGloballyEnabled() globallyEnabled} attribute.
     * @param globallyEnabled The value for globallyEnabled 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder globallyEnabled(GloballyEnabled globallyEnabled) {
      this.globallyEnabled = Objects.requireNonNull(globallyEnabled, "globallyEnabled");
      initBits &= ~INIT_BIT_GLOBALLY_ENABLED;
      return this;
    }

    /**
     * Adds one element to {@link UpdateSecurityGroupRequest#getRules() rules} list.
     * @param element A rules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(Rule element) {
      this.rules.add(Objects.requireNonNull(element, "rules element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An array of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(Rule... elements) {
      for (Rule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(Iterable<? extends Rule> elements) {
      this.rules.clear();
      return addAllRules(elements);
    }

    /**
     * Adds elements to {@link UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRules(Iterable<? extends Rule> elements) {
      for (Rule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
     * @return An immutable instance of UpdateSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_GLOBALLY_ENABLED) != 0) attributes.add("globallyEnabled");
      return "Cannot build UpdateSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
