package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Service Binding operation.
 */
@Generated(from = "_CreateServiceBindingRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateServiceBindingRequest
    extends org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingRequest {
  private final @Nullable String name;
  private final ServiceBindingRelationships relationships;
  private final ServiceBindingType type;
  private final @Nullable Map<String, Object> parameters;
  private final @Nullable Metadata metadata;

  private CreateServiceBindingRequest(CreateServiceBindingRequest.Builder builder) {
    this.name = builder.name;
    this.relationships = builder.relationships;
    this.type = builder.type;
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.metadata = builder.metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public ServiceBindingRelationships getRelationships() {
    return relationships;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public ServiceBindingType getType() {
    return type;
  }

  /**
   * The parameters
   */
  @JsonProperty("parameters")
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceBindingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceBindingRequest
        && equalTo(0, (CreateServiceBindingRequest) another);
  }

  private boolean equalTo(int synthetic, CreateServiceBindingRequest another) {
    return Objects.equals(name, another.name)
        && relationships.equals(another.relationships)
        && type.equals(another.type)
        && Objects.equals(parameters, another.parameters)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code relationships}, {@code type}, {@code parameters}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(parameters);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceBindingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceBindingRequest{"
        + "name=" + name
        + ", relationships=" + relationships
        + ", type=" + type
        + ", parameters=" + parameters
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateServiceBindingRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingRequest {
    String name;
    ServiceBindingRelationships relationships;
    ServiceBindingType type;
    Map<String, Object> parameters = null;
    Metadata metadata;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(ServiceBindingRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("type")
    public void setType(ServiceBindingType type) {
      this.type = type;
    }
    @JsonProperty("parameters")
    public void setParameters(@Nullable Map<String, Object> parameters) {
      this.parameters = parameters;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceBindingRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceBindingType getType() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getParameters() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateServiceBindingRequest fromJson(Json json) {
    CreateServiceBindingRequest.Builder builder = CreateServiceBindingRequest.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.parameters != null) {
      builder.putAllParameters(json.parameters);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  private static CreateServiceBindingRequest validate(CreateServiceBindingRequest instance) {
    instance.validateParameters();
    return instance;
  }

  /**
   * Creates a builder for {@link CreateServiceBindingRequest CreateServiceBindingRequest}.
   * <pre>
   * CreateServiceBindingRequest.builder()
   *    .name(String | null) // nullable {@link CreateServiceBindingRequest#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.servicebindings.ServiceBindingRelationships) // required {@link CreateServiceBindingRequest#getRelationships() relationships}
   *    .type(org.cloudfoundry.client.v3.servicebindings.ServiceBindingType) // required {@link CreateServiceBindingRequest#getType() type}
   *    .parameters(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link CreateServiceBindingRequest#getParameters() parameters}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateServiceBindingRequest#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new CreateServiceBindingRequest builder
   */
  public static CreateServiceBindingRequest.Builder builder() {
    return new CreateServiceBindingRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceBindingRequest CreateServiceBindingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateServiceBindingRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_RELATIONSHIPS = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private ServiceBindingRelationships relationships;
    private ServiceBindingType type;
    private Map<String, Object> parameters = null;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceBindingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceBindingRequest instance) {
      return from((_CreateServiceBindingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceBindingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceBindingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      relationships(instance.getRelationships());
      type(instance.getType());
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBindingRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBindingRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(ServiceBindingRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBindingRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(ServiceBindingType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceBindingRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceBindingRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateServiceBindingRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateServiceBindingRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> entries) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBindingRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceBindingRequest CreateServiceBindingRequest}.
     * @return An immutable instance of CreateServiceBindingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceBindingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CreateServiceBindingRequest.validate(new CreateServiceBindingRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CreateServiceBindingRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
