package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Service Binding Details operation.
 */
@Generated(from = "_GetServiceBindingDetailsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetServiceBindingDetailsRequest
    extends org.cloudfoundry.client.v3.servicebindings._GetServiceBindingDetailsRequest {
  private final String serviceBindingId;

  private GetServiceBindingDetailsRequest(GetServiceBindingDetailsRequest.Builder builder) {
    this.serviceBindingId = builder.serviceBindingId;
  }

  /**
   * The service binding id
   */
  @Override
  public String getServiceBindingId() {
    return serviceBindingId;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceBindingDetailsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceBindingDetailsRequest
        && equalTo(0, (GetServiceBindingDetailsRequest) another);
  }

  private boolean equalTo(int synthetic, GetServiceBindingDetailsRequest another) {
    return serviceBindingId.equals(another.serviceBindingId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceBindingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceBindingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceBindingDetailsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceBindingDetailsRequest{"
        + "serviceBindingId=" + serviceBindingId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceBindingDetailsRequest GetServiceBindingDetailsRequest}.
   * <pre>
   * GetServiceBindingDetailsRequest.builder()
   *    .serviceBindingId(String) // required {@link GetServiceBindingDetailsRequest#getServiceBindingId() serviceBindingId}
   *    .build();
   * </pre>
   * @return A new GetServiceBindingDetailsRequest builder
   */
  public static GetServiceBindingDetailsRequest.Builder builder() {
    return new GetServiceBindingDetailsRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceBindingDetailsRequest GetServiceBindingDetailsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetServiceBindingDetailsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BINDING_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceBindingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceBindingDetailsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceBindingDetailsRequest instance) {
      return from((_GetServiceBindingDetailsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceBindingDetailsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceBindingDetailsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceBindingId(instance.getServiceBindingId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingDetailsRequest#getServiceBindingId() serviceBindingId} attribute.
     * @param serviceBindingId The value for serviceBindingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String serviceBindingId) {
      this.serviceBindingId = Objects.requireNonNull(serviceBindingId, "serviceBindingId");
      initBits &= ~INIT_BIT_SERVICE_BINDING_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServiceBindingDetailsRequest GetServiceBindingDetailsRequest}.
     * @return An immutable instance of GetServiceBindingDetailsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceBindingDetailsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceBindingDetailsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_BINDING_ID) != 0) attributes.add("serviceBindingId");
      return "Cannot build GetServiceBindingDetailsRequest, some of required attributes are not set " + attributes;
    }
  }
}
