package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Service Binding operation
 */
@Generated(from = "_UpdateServiceBindingRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceBindingRequest
    extends org.cloudfoundry.client.v3.servicebindings._UpdateServiceBindingRequest {
  private final String serviceBindingId;
  private final @Nullable Metadata metadata;

  private UpdateServiceBindingRequest(UpdateServiceBindingRequest.Builder builder) {
    this.serviceBindingId = builder.serviceBindingId;
    this.metadata = builder.metadata;
  }

  /**
   * The service binding id
   */
  @JsonProperty("serviceBindingId")
  @JsonIgnore
  @Override
  public String getServiceBindingId() {
    return serviceBindingId;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceBindingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceBindingRequest
        && equalTo(0, (UpdateServiceBindingRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateServiceBindingRequest another) {
    return serviceBindingId.equals(another.serviceBindingId)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code serviceBindingId}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceBindingId.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceBindingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceBindingRequest{"
        + "serviceBindingId=" + serviceBindingId
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServiceBindingRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebindings._UpdateServiceBindingRequest {
    String serviceBindingId;
    Metadata metadata;
    @JsonProperty("serviceBindingId")
    @JsonIgnore
    public void setServiceBindingId(String serviceBindingId) {
      this.serviceBindingId = serviceBindingId;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public String getServiceBindingId() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServiceBindingRequest fromJson(Json json) {
    UpdateServiceBindingRequest.Builder builder = UpdateServiceBindingRequest.builder();
    if (json.serviceBindingId != null) {
      builder.serviceBindingId(json.serviceBindingId);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServiceBindingRequest UpdateServiceBindingRequest}.
   * <pre>
   * UpdateServiceBindingRequest.builder()
   *    .serviceBindingId(String) // required {@link UpdateServiceBindingRequest#getServiceBindingId() serviceBindingId}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateServiceBindingRequest#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new UpdateServiceBindingRequest builder
   */
  public static UpdateServiceBindingRequest.Builder builder() {
    return new UpdateServiceBindingRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceBindingRequest UpdateServiceBindingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceBindingRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BINDING_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceBindingId;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceBindingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceBindingRequest instance) {
      return from((_UpdateServiceBindingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceBindingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceBindingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceBindingId(instance.getServiceBindingId());
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBindingRequest#getServiceBindingId() serviceBindingId} attribute.
     * @param serviceBindingId The value for serviceBindingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String serviceBindingId) {
      this.serviceBindingId = Objects.requireNonNull(serviceBindingId, "serviceBindingId");
      initBits &= ~INIT_BIT_SERVICE_BINDING_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBindingRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceBindingRequest UpdateServiceBindingRequest}.
     * @return An immutable instance of UpdateServiceBindingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceBindingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceBindingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_BINDING_ID) != 0) attributes.add("serviceBindingId");
      return "Cannot build UpdateServiceBindingRequest, some of required attributes are not set " + attributes;
    }
  }
}
