package org.cloudfoundry.client.v3.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Service operation
 */
@Generated(from = "_CreateServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateServiceInstanceRequest
    extends org.cloudfoundry.client.v3.serviceinstances._CreateServiceInstanceRequest {
  private final ServiceInstanceType type;
  private final String name;
  private final @Nullable ServiceInstanceRelationships relationships;
  private final @Nullable List<String> tags;
  private final @Nullable Map<String, Object> parameters;
  private final @Nullable Metadata metadata;
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable String syslogDrainUrl;
  private final @Nullable String routeServiceUrl;

  private CreateServiceInstanceRequest(CreateServiceInstanceRequest.Builder builder) {
    this.type = builder.type;
    this.name = builder.name;
    this.relationships = builder.relationships;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.metadata = builder.metadata;
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.syslogDrainUrl = builder.syslogDrainUrl;
    this.routeServiceUrl = builder.routeServiceUrl;
  }

  /**
   * The type of the service instance
   */
  @JsonProperty("type")
  @Override
  public ServiceInstanceType getType() {
    return type;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable ServiceInstanceRelationships getRelationships() {
    return relationships;
  }

  /**
   * A list of tags for the service instance
   */
  @JsonProperty("tags")
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * The service creation parameters
   */
  @JsonProperty("parameters")
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The user provided service credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The syslog drain url
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * The route service url
   */
  @JsonProperty("route_service_url")
  @Override
  public @Nullable String getRouteServiceUrl() {
    return routeServiceUrl;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceInstanceRequest
        && equalTo(0, (CreateServiceInstanceRequest) another);
  }

  private boolean equalTo(int synthetic, CreateServiceInstanceRequest another) {
    return type.equals(another.type)
        && name.equals(another.name)
        && Objects.equals(relationships, another.relationships)
        && Objects.equals(tags, another.tags)
        && Objects.equals(parameters, another.parameters)
        && Objects.equals(metadata, another.metadata)
        && Objects.equals(credentials, another.credentials)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl)
        && Objects.equals(routeServiceUrl, another.routeServiceUrl);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code name}, {@code relationships}, {@code tags}, {@code parameters}, {@code metadata}, {@code credentials}, {@code syslogDrainUrl}, {@code routeServiceUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(relationships);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + Objects.hashCode(parameters);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(credentials);
    h += (h << 5) + Objects.hashCode(syslogDrainUrl);
    h += (h << 5) + Objects.hashCode(routeServiceUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceInstanceRequest{"
        + "type=" + type
        + ", name=" + name
        + ", relationships=" + relationships
        + ", tags=" + tags
        + ", parameters=" + parameters
        + ", metadata=" + metadata
        + ", credentials=" + credentials
        + ", syslogDrainUrl=" + syslogDrainUrl
        + ", routeServiceUrl=" + routeServiceUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateServiceInstanceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceinstances._CreateServiceInstanceRequest {
    ServiceInstanceType type;
    String name;
    ServiceInstanceRelationships relationships;
    List<String> tags = null;
    Map<String, Object> parameters = null;
    Metadata metadata;
    Map<String, Object> credentials = null;
    String syslogDrainUrl;
    String routeServiceUrl;
    @JsonProperty("type")
    public void setType(ServiceInstanceType type) {
      this.type = type;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable ServiceInstanceRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("tags")
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("parameters")
    public void setParameters(@Nullable Map<String, Object> parameters) {
      this.parameters = parameters;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @JsonProperty("route_service_url")
    public void setRouteServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
    }
    @Override
    public ServiceInstanceType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceInstanceRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getParameters() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteServiceUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateServiceInstanceRequest fromJson(Json json) {
    CreateServiceInstanceRequest.Builder builder = CreateServiceInstanceRequest.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.parameters != null) {
      builder.putAllParameters(json.parameters);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    if (json.routeServiceUrl != null) {
      builder.routeServiceUrl(json.routeServiceUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
   * <pre>
   * CreateServiceInstanceRequest.builder()
   *    .type(org.cloudfoundry.client.v3.serviceinstances.ServiceInstanceType) // required {@link CreateServiceInstanceRequest#getType() type}
   *    .name(String) // required {@link CreateServiceInstanceRequest#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.serviceinstances.ServiceInstanceRelationships | null) // nullable {@link CreateServiceInstanceRequest#getRelationships() relationships}
   *    .tags(List&amp;lt;String&amp;gt; | null) // nullable {@link CreateServiceInstanceRequest#getTags() tags}
   *    .parameters(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link CreateServiceInstanceRequest#getParameters() parameters}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateServiceInstanceRequest#getMetadata() metadata}
   *    .credentials(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link CreateServiceInstanceRequest#getCredentials() credentials}
   *    .syslogDrainUrl(String | null) // nullable {@link CreateServiceInstanceRequest#getSyslogDrainUrl() syslogDrainUrl}
   *    .routeServiceUrl(String | null) // nullable {@link CreateServiceInstanceRequest#getRouteServiceUrl() routeServiceUrl}
   *    .build();
   * </pre>
   * @return A new CreateServiceInstanceRequest builder
   */
  public static CreateServiceInstanceRequest.Builder builder() {
    return new CreateServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private ServiceInstanceType type;
    private String name;
    private ServiceInstanceRelationships relationships;
    private List<String> tags = null;
    private Map<String, Object> parameters = null;
    private Metadata metadata;
    private Map<String, Object> credentials = null;
    private String syslogDrainUrl;
    private String routeServiceUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceInstanceRequest instance) {
      return from((_CreateServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      name(instance.getName());
      ServiceInstanceRelationships relationshipsValue = instance.getRelationships();
      if (relationshipsValue != null) {
        relationships(relationshipsValue);
      }
      List<String> tagsValue = instance.getTags();
      if (tagsValue != null) {
        addAllTags(tagsValue);
      }
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      Map<String, Object> credentialsValue = instance.getCredentials();
      if (credentialsValue != null) {
        putAllCredentials(credentialsValue);
      }
      String syslogDrainUrlValue = instance.getSyslogDrainUrl();
      if (syslogDrainUrlValue != null) {
        syslogDrainUrl(syslogDrainUrlValue);
      }
      String routeServiceUrlValue = instance.getRouteServiceUrl();
      if (routeServiceUrlValue != null) {
        routeServiceUrl(routeServiceUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(ServiceInstanceType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(@Nullable ServiceInstanceRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Adds one element to {@link CreateServiceInstanceRequest#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceInstanceRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, value == null ? "parameters value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, v == null ? "parameters value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> entries) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, v == null ? "parameters value for key: " + k : null));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceInstanceRequest#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(
          Objects.requireNonNull(key, "credentials key"),
          Objects.requireNonNull(value, value == null ? "credentials value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(
          Objects.requireNonNull(k, "credentials key"),
          Objects.requireNonNull(v, v == null ? "credentials value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credentials(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.credentials.put(
            Objects.requireNonNull(k, "credentials key"),
            Objects.requireNonNull(v, v == null ? "credentials value for key: " + k : null));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getRouteServiceUrl() routeServiceUrl} attribute.
     * @param routeServiceUrl The value for routeServiceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
     * @return An immutable instance of CreateServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
