package org.cloudfoundry.client.v3.serviceinstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _GetManagedServiceParametersRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetManagedServiceParametersRequest.builder()}.
 */
@Generated(from = "_GetManagedServiceParametersRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetManagedServiceParametersRequest
    extends org.cloudfoundry.client.v3.serviceinstances._GetManagedServiceParametersRequest {
  private final String serviceInstanceId;

  private GetManagedServiceParametersRequest(GetManagedServiceParametersRequest.Builder builder) {
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The managed service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code GetManagedServiceParametersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetManagedServiceParametersRequest
        && equalTo(0, (GetManagedServiceParametersRequest) another);
  }

  private boolean equalTo(int synthetic, GetManagedServiceParametersRequest another) {
    return serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetManagedServiceParametersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetManagedServiceParametersRequest{"
        + "serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link GetManagedServiceParametersRequest GetManagedServiceParametersRequest}.
   * <pre>
   * GetManagedServiceParametersRequest.builder()
   *    .serviceInstanceId(String) // required {@link GetManagedServiceParametersRequest#getServiceInstanceId() serviceInstanceId}
   *    .build();
   * </pre>
   * @return A new GetManagedServiceParametersRequest builder
   */
  public static GetManagedServiceParametersRequest.Builder builder() {
    return new GetManagedServiceParametersRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetManagedServiceParametersRequest GetManagedServiceParametersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetManagedServiceParametersRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetManagedServiceParametersRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetManagedServiceParametersRequest instance) {
      return from((_GetManagedServiceParametersRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetManagedServiceParametersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetManagedServiceParametersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetManagedServiceParametersRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link GetManagedServiceParametersRequest GetManagedServiceParametersRequest}.
     * @return An immutable instance of GetManagedServiceParametersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetManagedServiceParametersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetManagedServiceParametersRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build GetManagedServiceParametersRequest, some of required attributes are not set " + attributes;
    }
  }
}
