package org.cloudfoundry.client.v3.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Service Instances operation.
 */
@Generated(from = "_ListServiceInstancesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServiceInstancesRequest
    extends org.cloudfoundry.client.v3.serviceinstances._ListServiceInstancesRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final @Nullable String labelSelector;
  private final List<String> serviceInstanceNames;
  private final List<String> spaceIds;

  private ListServiceInstancesRequest(ListServiceInstancesRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.labelSelector = builder.labelSelector;
    this.serviceInstanceNames = createUnmodifiableList(true, builder.serviceInstanceNames);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The metadata query
   */
  @Override
  public @Nullable String getLabelSelector() {
    return labelSelector;
  }

  /**
   * The service instance names
   */
  @Override
  public List<String> getServiceInstanceNames() {
    return serviceInstanceNames;
  }

  /**
   * The space ids
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceInstancesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceInstancesRequest
        && equalTo(0, (ListServiceInstancesRequest) another);
  }

  private boolean equalTo(int synthetic, ListServiceInstancesRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && Objects.equals(labelSelector, another.labelSelector)
        && serviceInstanceNames.equals(another.serviceInstanceNames)
        && spaceIds.equals(another.spaceIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code labelSelector}, {@code serviceInstanceNames}, {@code spaceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + Objects.hashCode(labelSelector);
    h += (h << 5) + serviceInstanceNames.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceInstancesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceInstancesRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", labelSelector=" + labelSelector
        + ", serviceInstanceNames=" + serviceInstanceNames
        + ", spaceIds=" + spaceIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceInstancesRequest ListServiceInstancesRequest}.
   * <pre>
   * ListServiceInstancesRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListServiceInstancesRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListServiceInstancesRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListServiceInstancesRequest#getPerPage() perPage}
   *    .labelSelector(String | null) // nullable {@link ListServiceInstancesRequest#getLabelSelector() labelSelector}
   *    .serviceInstanceName|addAllServiceInstanceNames(String) // {@link ListServiceInstancesRequest#getServiceInstanceNames() serviceInstanceNames} elements
   *    .spaceId|addAllSpaceIds(String) // {@link ListServiceInstancesRequest#getSpaceIds() spaceIds} elements
   *    .build();
   * </pre>
   * @return A new ListServiceInstancesRequest builder
   */
  public static ListServiceInstancesRequest.Builder builder() {
    return new ListServiceInstancesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceInstancesRequest ListServiceInstancesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServiceInstancesRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private String labelSelector;
    private List<String> serviceInstanceNames = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceInstancesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceInstancesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServiceInstancesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServiceInstancesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.serviceinstances._ListServiceInstancesRequest) {
        org.cloudfoundry.client.v3.serviceinstances._ListServiceInstancesRequest instance = (org.cloudfoundry.client.v3.serviceinstances._ListServiceInstancesRequest) object;
        String labelSelectorValue = instance.getLabelSelector();
        if (labelSelectorValue != null) {
          labelSelector(labelSelectorValue);
        }
        addAllServiceInstanceNames(instance.getServiceInstanceNames());
        addAllSpaceIds(instance.getSpaceIds());
      }
    }

    /**
     * Initializes the value for the {@link ListServiceInstancesRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceInstancesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceInstancesRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceInstancesRequest#getLabelSelector() labelSelector} attribute.
     * @param labelSelector The value for labelSelector (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(@Nullable String labelSelector) {
      this.labelSelector = labelSelector;
      return this;
    }

    /**
     * Adds one element to {@link ListServiceInstancesRequest#getServiceInstanceNames() serviceInstanceNames} list.
     * @param element A serviceInstanceNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String element) {
      this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceInstancesRequest#getServiceInstanceNames() serviceInstanceNames} list.
     * @param elements An array of serviceInstanceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceNames(String... elements) {
      for (String element : elements) {
        this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceInstancesRequest#getServiceInstanceNames() serviceInstanceNames} list.
     * @param elements An iterable of serviceInstanceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceNames(Iterable<String> elements) {
      this.serviceInstanceNames.clear();
      return addAllServiceInstanceNames(elements);
    }

    /**
     * Adds elements to {@link ListServiceInstancesRequest#getServiceInstanceNames() serviceInstanceNames} list.
     * @param elements An iterable of serviceInstanceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceNames(Iterable<String> elements) {
      for (String element : elements) {
        this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListServiceInstancesRequest ListServiceInstancesRequest}.
     * @return An immutable instance of ListServiceInstancesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceInstancesRequest build() {
      return new ListServiceInstancesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
