package org.cloudfoundry.client.v3.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * The response payload for the Update Service operation
 */
@Generated(from = "_UpdateServiceInstanceResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceInstanceResponse
    extends org.cloudfoundry.client.v3.serviceinstances._UpdateServiceInstanceResponse {
  private final String jobId;
  private final ServiceInstanceResource serviceInstance;

  private UpdateServiceInstanceResponse(UpdateServiceInstanceResponse.Builder builder) {
    this.jobId = builder.jobId;
    this.serviceInstance = builder.serviceInstance;
  }

  /**
   * @return The value of the {@code jobId} attribute
   */
  @JsonProperty("jobId")
  @Override
  public Optional<String> getJobId() {
    return Optional.ofNullable(jobId);
  }

  /**
   * @return The value of the {@code serviceInstance} attribute
   */
  @JsonProperty("serviceInstance")
  @Override
  public Optional<ServiceInstanceResource> getServiceInstance() {
    return Optional.ofNullable(serviceInstance);
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceInstanceResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceInstanceResponse
        && equalTo(0, (UpdateServiceInstanceResponse) another);
  }

  private boolean equalTo(int synthetic, UpdateServiceInstanceResponse another) {
    return Objects.equals(jobId, another.jobId)
        && Objects.equals(serviceInstance, another.serviceInstance);
  }

  /**
   * Computes a hash code from attributes: {@code jobId}, {@code serviceInstance}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(jobId);
    h += (h << 5) + Objects.hashCode(serviceInstance);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceInstanceResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UpdateServiceInstanceResponse{");
    if (jobId != null) {
      builder.append("jobId=").append(jobId);
    }
    if (serviceInstance != null) {
      if (builder.length() > 30) builder.append(", ");
      builder.append("serviceInstance=").append(serviceInstance);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServiceInstanceResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceinstances._UpdateServiceInstanceResponse {
    Optional<String> jobId = Optional.empty();
    Optional<ServiceInstanceResource> serviceInstance = Optional.empty();
    @JsonProperty("jobId")
    public void setJobId(Optional<String> jobId) {
      this.jobId = jobId;
    }
    @JsonProperty("serviceInstance")
    public void setServiceInstance(Optional<ServiceInstanceResource> serviceInstance) {
      this.serviceInstance = serviceInstance;
    }
    @Override
    public Optional<String> getJobId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ServiceInstanceResource> getServiceInstance() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServiceInstanceResponse fromJson(Json json) {
    UpdateServiceInstanceResponse.Builder builder = UpdateServiceInstanceResponse.builder();
    if (json.jobId != null) {
      builder.jobId(json.jobId);
    }
    if (json.serviceInstance != null) {
      builder.serviceInstance(json.serviceInstance);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServiceInstanceResponse UpdateServiceInstanceResponse}.
   * <pre>
   * UpdateServiceInstanceResponse.builder()
   *    .jobId(String) // optional {@link UpdateServiceInstanceResponse#getJobId() jobId}
   *    .serviceInstance(ServiceInstanceResource) // optional {@link UpdateServiceInstanceResponse#getServiceInstance() serviceInstance}
   *    .build();
   * </pre>
   * @return A new UpdateServiceInstanceResponse builder
   */
  public static UpdateServiceInstanceResponse.Builder builder() {
    return new UpdateServiceInstanceResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceInstanceResponse UpdateServiceInstanceResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceInstanceResponse", generator = "Immutables")
  public static final class Builder {
    private String jobId;
    private ServiceInstanceResource serviceInstance;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceInstanceResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceInstanceResponse instance) {
      return from((_UpdateServiceInstanceResponse) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceInstanceResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceInstanceResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> jobIdOptional = instance.getJobId();
      if (jobIdOptional.isPresent()) {
        jobId(jobIdOptional);
      }
      Optional<ServiceInstanceResource> serviceInstanceOptional = instance.getServiceInstance();
      if (serviceInstanceOptional.isPresent()) {
        serviceInstance(serviceInstanceOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link UpdateServiceInstanceResponse#getJobId() jobId} to jobId.
     * @param jobId The value for jobId
     * @return {@code this} builder for chained invocation
     */
    public final Builder jobId(String jobId) {
      this.jobId = Objects.requireNonNull(jobId, "jobId");
      return this;
    }

    /**
     * Initializes the optional value {@link UpdateServiceInstanceResponse#getJobId() jobId} to jobId.
     * @param jobId The value for jobId
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jobId")
    public final Builder jobId(Optional<String> jobId) {
      this.jobId = jobId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UpdateServiceInstanceResponse#getServiceInstance() serviceInstance} to serviceInstance.
     * @param serviceInstance The value for serviceInstance
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceInstance(ServiceInstanceResource serviceInstance) {
      this.serviceInstance = Objects.requireNonNull(serviceInstance, "serviceInstance");
      return this;
    }

    /**
     * Initializes the optional value {@link UpdateServiceInstanceResponse#getServiceInstance() serviceInstance} to serviceInstance.
     * @param serviceInstance The value for serviceInstance
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("serviceInstance")
    public final Builder serviceInstance(Optional<? extends ServiceInstanceResource> serviceInstance) {
      this.serviceInstance = serviceInstance.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceInstanceResponse UpdateServiceInstanceResponse}.
     * @return An immutable instance of UpdateServiceInstanceResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceInstanceResponse build() {
      return new UpdateServiceInstanceResponse(this);
    }
  }
}
