package org.cloudfoundry.client.v3.serviceofferings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Service Offering operation.
 */
@Generated(from = "_DeleteServiceOfferingRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteServiceOfferingRequest
    extends org.cloudfoundry.client.v3.serviceofferings._DeleteServiceOfferingRequest {
  private final @Nullable Boolean purge;
  private final String serviceOfferingId;

  private DeleteServiceOfferingRequest(DeleteServiceOfferingRequest.Builder builder) {
    this.purge = builder.purge;
    this.serviceOfferingId = builder.serviceOfferingId;
  }

  /**
   * Whether any service plans, instances, and bindings associated with this service offering will also be deleted
   */
  @Override
  public @Nullable Boolean getPurge() {
    return purge;
  }

  /**
   * The service offering id
   */
  @Override
  public String getServiceOfferingId() {
    return serviceOfferingId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceOfferingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceOfferingRequest
        && equalTo(0, (DeleteServiceOfferingRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteServiceOfferingRequest another) {
    return Objects.equals(purge, another.purge)
        && serviceOfferingId.equals(another.serviceOfferingId);
  }

  /**
   * Computes a hash code from attributes: {@code purge}, {@code serviceOfferingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(purge);
    h += (h << 5) + serviceOfferingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceOfferingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceOfferingRequest{"
        + "purge=" + purge
        + ", serviceOfferingId=" + serviceOfferingId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServiceOfferingRequest DeleteServiceOfferingRequest}.
   * <pre>
   * DeleteServiceOfferingRequest.builder()
   *    .purge(Boolean | null) // nullable {@link DeleteServiceOfferingRequest#getPurge() purge}
   *    .serviceOfferingId(String) // required {@link DeleteServiceOfferingRequest#getServiceOfferingId() serviceOfferingId}
   *    .build();
   * </pre>
   * @return A new DeleteServiceOfferingRequest builder
   */
  public static DeleteServiceOfferingRequest.Builder builder() {
    return new DeleteServiceOfferingRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceOfferingRequest DeleteServiceOfferingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteServiceOfferingRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_OFFERING_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean purge;
    private String serviceOfferingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceOfferingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceOfferingRequest instance) {
      return from((_DeleteServiceOfferingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceOfferingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceOfferingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean purgeValue = instance.getPurge();
      if (purgeValue != null) {
        purge(purgeValue);
      }
      serviceOfferingId(instance.getServiceOfferingId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceOfferingRequest#getPurge() purge} attribute.
     * @param purge The value for purge (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder purge(@Nullable Boolean purge) {
      this.purge = purge;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceOfferingRequest#getServiceOfferingId() serviceOfferingId} attribute.
     * @param serviceOfferingId The value for serviceOfferingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingId(String serviceOfferingId) {
      this.serviceOfferingId = Objects.requireNonNull(serviceOfferingId, "serviceOfferingId");
      initBits &= ~INIT_BIT_SERVICE_OFFERING_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceOfferingRequest DeleteServiceOfferingRequest}.
     * @return An immutable instance of DeleteServiceOfferingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceOfferingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServiceOfferingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_OFFERING_ID) != 0) attributes.add("serviceOfferingId");
      return "Cannot build DeleteServiceOfferingRequest, some of required attributes are not set " + attributes;
    }
  }
}
