package org.cloudfoundry.client.v3.serviceofferings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Service Offerings operation
 */
@Generated(from = "_ListServiceOfferingsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServiceOfferingsRequest
    extends org.cloudfoundry.client.v3.serviceofferings._ListServiceOfferingsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final @Nullable Boolean available;
  private final @Nullable List<String> labelSelector;
  private final @Nullable List<String> names;
  private final @Nullable List<String> organizationIds;
  private final @Nullable List<String> serviceBrokerIds;
  private final @Nullable List<String> serviceBrokerNames;
  private final @Nullable List<String> spaceIds;

  private ListServiceOfferingsRequest(ListServiceOfferingsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.available = builder.available;
    this.labelSelector = builder.labelSelector == null ? null : createUnmodifiableList(true, builder.labelSelector);
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.serviceBrokerIds = builder.serviceBrokerIds == null ? null : createUnmodifiableList(true, builder.serviceBrokerIds);
    this.serviceBrokerNames = builder.serviceBrokerNames == null ? null : createUnmodifiableList(true, builder.serviceBrokerNames);
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * Whether the service offering is available
   */
  @Override
  public @Nullable Boolean getAvailable() {
    return available;
  }

  /**
   * List of label selectors
   */
  @Override
  public @Nullable List<String> getLabelSelector() {
    return labelSelector;
  }

  /**
   * List of names to filter by
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * List of organization ids to filter by
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * List of service broker ids to filter by
   */
  @Override
  public @Nullable List<String> getServiceBrokerIds() {
    return serviceBrokerIds;
  }

  /**
   * List of service broker names to filter by
   */
  @Override
  public @Nullable List<String> getServiceBrokerNames() {
    return serviceBrokerNames;
  }

  /**
   * List of space ids to filter by
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceOfferingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceOfferingsRequest
        && equalTo(0, (ListServiceOfferingsRequest) another);
  }

  private boolean equalTo(int synthetic, ListServiceOfferingsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && Objects.equals(available, another.available)
        && Objects.equals(labelSelector, another.labelSelector)
        && Objects.equals(names, another.names)
        && Objects.equals(organizationIds, another.organizationIds)
        && Objects.equals(serviceBrokerIds, another.serviceBrokerIds)
        && Objects.equals(serviceBrokerNames, another.serviceBrokerNames)
        && Objects.equals(spaceIds, another.spaceIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code available}, {@code labelSelector}, {@code names}, {@code organizationIds}, {@code serviceBrokerIds}, {@code serviceBrokerNames}, {@code spaceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + Objects.hashCode(available);
    h += (h << 5) + Objects.hashCode(labelSelector);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + Objects.hashCode(serviceBrokerIds);
    h += (h << 5) + Objects.hashCode(serviceBrokerNames);
    h += (h << 5) + Objects.hashCode(spaceIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceOfferingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceOfferingsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", available=" + available
        + ", labelSelector=" + labelSelector
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", serviceBrokerIds=" + serviceBrokerIds
        + ", serviceBrokerNames=" + serviceBrokerNames
        + ", spaceIds=" + spaceIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceOfferingsRequest ListServiceOfferingsRequest}.
   * <pre>
   * ListServiceOfferingsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListServiceOfferingsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListServiceOfferingsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListServiceOfferingsRequest#getPerPage() perPage}
   *    .available(Boolean | null) // nullable {@link ListServiceOfferingsRequest#getAvailable() available}
   *    .labelSelector(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServiceOfferingsRequest#getLabelSelector() labelSelector}
   *    .names(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServiceOfferingsRequest#getNames() names}
   *    .organizationIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServiceOfferingsRequest#getOrganizationIds() organizationIds}
   *    .serviceBrokerIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServiceOfferingsRequest#getServiceBrokerIds() serviceBrokerIds}
   *    .serviceBrokerNames(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServiceOfferingsRequest#getServiceBrokerNames() serviceBrokerNames}
   *    .spaceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServiceOfferingsRequest#getSpaceIds() spaceIds}
   *    .build();
   * </pre>
   * @return A new ListServiceOfferingsRequest builder
   */
  public static ListServiceOfferingsRequest.Builder builder() {
    return new ListServiceOfferingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceOfferingsRequest ListServiceOfferingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServiceOfferingsRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private Boolean available;
    private List<String> labelSelector = null;
    private List<String> names = null;
    private List<String> organizationIds = null;
    private List<String> serviceBrokerIds = null;
    private List<String> serviceBrokerNames = null;
    private List<String> spaceIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceOfferingsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceOfferingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServiceOfferingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServiceOfferingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.serviceofferings._ListServiceOfferingsRequest) {
        org.cloudfoundry.client.v3.serviceofferings._ListServiceOfferingsRequest instance = (org.cloudfoundry.client.v3.serviceofferings._ListServiceOfferingsRequest) object;
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        List<String> serviceBrokerNamesValue = instance.getServiceBrokerNames();
        if (serviceBrokerNamesValue != null) {
          addAllServiceBrokerNames(serviceBrokerNamesValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
        Boolean availableValue = instance.getAvailable();
        if (availableValue != null) {
          available(availableValue);
        }
        List<String> labelSelectorValue = instance.getLabelSelector();
        if (labelSelectorValue != null) {
          addAllLabelSelector(labelSelectorValue);
        }
        List<String> serviceBrokerIdsValue = instance.getServiceBrokerIds();
        if (serviceBrokerIdsValue != null) {
          addAllServiceBrokerIds(serviceBrokerIdsValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListServiceOfferingsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceOfferingsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceOfferingsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceOfferingsRequest#getAvailable() available} attribute.
     * @param available The value for available (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder available(@Nullable Boolean available) {
      this.available = available;
      return this;
    }

    /**
     * Adds one element to {@link ListServiceOfferingsRequest#getLabelSelector() labelSelector} list.
     * @param element A labelSelector element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(String element) {
      if (this.labelSelector == null) {
        this.labelSelector = new ArrayList<String>();
      }
      this.labelSelector.add(Objects.requireNonNull(element, "labelSelector element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getLabelSelector() labelSelector} list.
     * @param elements An array of labelSelector elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(String... elements) {
      if (this.labelSelector == null) {
        this.labelSelector = new ArrayList<String>();
      }
      for (String element : elements) {
        this.labelSelector.add(Objects.requireNonNull(element, "labelSelector element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceOfferingsRequest#getLabelSelector() labelSelector} list.
     * @param elements An iterable of labelSelector elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.labelSelector = null;
        return this;
      }
      this.labelSelector = new ArrayList<String>();
      return addAllLabelSelector(elements);
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getLabelSelector() labelSelector} list.
     * @param elements An iterable of labelSelector elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLabelSelector(Iterable<String> elements) {
      Objects.requireNonNull(elements, "labelSelector element");
      if (this.labelSelector == null) {
        this.labelSelector = new ArrayList<String>();
      }
      for (String element : elements) {
        this.labelSelector.add(Objects.requireNonNull(element, "labelSelector element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceOfferingsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceOfferingsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceOfferingsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceOfferingsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceOfferingsRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param element A serviceBrokerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String element) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An array of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(String... elements) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceOfferingsRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBrokerIds = null;
        return this;
      }
      this.serviceBrokerIds = new ArrayList<String>();
      return addAllServiceBrokerIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBrokerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBrokerIds element");
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceOfferingsRequest#getServiceBrokerNames() serviceBrokerNames} list.
     * @param element A serviceBrokerNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerName(String element) {
      if (this.serviceBrokerNames == null) {
        this.serviceBrokerNames = new ArrayList<String>();
      }
      this.serviceBrokerNames.add(Objects.requireNonNull(element, "serviceBrokerNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getServiceBrokerNames() serviceBrokerNames} list.
     * @param elements An array of serviceBrokerNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerNames(String... elements) {
      if (this.serviceBrokerNames == null) {
        this.serviceBrokerNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerNames.add(Objects.requireNonNull(element, "serviceBrokerNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceOfferingsRequest#getServiceBrokerNames() serviceBrokerNames} list.
     * @param elements An iterable of serviceBrokerNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerNames(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBrokerNames = null;
        return this;
      }
      this.serviceBrokerNames = new ArrayList<String>();
      return addAllServiceBrokerNames(elements);
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getServiceBrokerNames() serviceBrokerNames} list.
     * @param elements An iterable of serviceBrokerNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBrokerNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBrokerNames element");
      if (this.serviceBrokerNames == null) {
        this.serviceBrokerNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerNames.add(Objects.requireNonNull(element, "serviceBrokerNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceOfferingsRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceOfferingsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceOfferingsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListServiceOfferingsRequest ListServiceOfferingsRequest}.
     * @return An immutable instance of ListServiceOfferingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceOfferingsRequest build() {
      return new ListServiceOfferingsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
