package org.cloudfoundry.client.v3.serviceofferings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Service Offering operation
 */
@Generated(from = "_UpdateServiceOfferingRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceOfferingRequest
    extends org.cloudfoundry.client.v3.serviceofferings._UpdateServiceOfferingRequest {
  private final @Nullable Metadata metadata;
  private final String serviceOfferingId;

  private UpdateServiceOfferingRequest(UpdateServiceOfferingRequest.Builder builder) {
    this.metadata = builder.metadata;
    this.serviceOfferingId = builder.serviceOfferingId;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The service offering id
   */
  @JsonProperty("serviceOfferingId")
  @JsonIgnore
  @Override
  public String getServiceOfferingId() {
    return serviceOfferingId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceOfferingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceOfferingRequest
        && equalTo(0, (UpdateServiceOfferingRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateServiceOfferingRequest another) {
    return Objects.equals(metadata, another.metadata)
        && serviceOfferingId.equals(another.serviceOfferingId);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code serviceOfferingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + serviceOfferingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceOfferingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceOfferingRequest{"
        + "metadata=" + metadata
        + ", serviceOfferingId=" + serviceOfferingId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServiceOfferingRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceofferings._UpdateServiceOfferingRequest {
    Metadata metadata;
    String serviceOfferingId;
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("serviceOfferingId")
    @JsonIgnore
    public void setServiceOfferingId(String serviceOfferingId) {
      this.serviceOfferingId = serviceOfferingId;
    }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceOfferingId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServiceOfferingRequest fromJson(Json json) {
    UpdateServiceOfferingRequest.Builder builder = UpdateServiceOfferingRequest.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.serviceOfferingId != null) {
      builder.serviceOfferingId(json.serviceOfferingId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServiceOfferingRequest UpdateServiceOfferingRequest}.
   * <pre>
   * UpdateServiceOfferingRequest.builder()
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateServiceOfferingRequest#getMetadata() metadata}
   *    .serviceOfferingId(String) // required {@link UpdateServiceOfferingRequest#getServiceOfferingId() serviceOfferingId}
   *    .build();
   * </pre>
   * @return A new UpdateServiceOfferingRequest builder
   */
  public static UpdateServiceOfferingRequest.Builder builder() {
    return new UpdateServiceOfferingRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceOfferingRequest UpdateServiceOfferingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceOfferingRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_OFFERING_ID = 0x1L;
    private long initBits = 0x1L;

    private Metadata metadata;
    private String serviceOfferingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceOfferingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceOfferingRequest instance) {
      return from((_UpdateServiceOfferingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceOfferingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceOfferingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      serviceOfferingId(instance.getServiceOfferingId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceOfferingRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceOfferingRequest#getServiceOfferingId() serviceOfferingId} attribute.
     * @param serviceOfferingId The value for serviceOfferingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingId(String serviceOfferingId) {
      this.serviceOfferingId = Objects.requireNonNull(serviceOfferingId, "serviceOfferingId");
      initBits &= ~INIT_BIT_SERVICE_OFFERING_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceOfferingRequest UpdateServiceOfferingRequest}.
     * @return An immutable instance of UpdateServiceOfferingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceOfferingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceOfferingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_OFFERING_ID) != 0) attributes.add("serviceOfferingId");
      return "Cannot build UpdateServiceOfferingRequest, some of required attributes are not set " + attributes;
    }
  }
}
