package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Broker Catalog information for a Service Plan
 */
@Generated(from = "_Features", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Features extends org.cloudfoundry.client.v3.serviceplans._Features {
  private final Boolean bindable;
  private final Boolean planUpdateable;

  private Features(Features.Builder builder) {
    this.bindable = builder.bindable;
    this.planUpdateable = builder.planUpdateable;
  }

  /**
   * Whether service instances of the service can be bound to applications
   */
  @JsonProperty("bindable")
  @Override
  public Boolean getBindable() {
    return bindable;
  }

  /**
   * Whether the service plan supports upgrade/downgrade for service plans
   */
  @JsonProperty("plan_updateable")
  @Override
  public Boolean getPlanUpdateable() {
    return planUpdateable;
  }

  /**
   * This instance is equal to all instances of {@code Features} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Features
        && equalTo(0, (Features) another);
  }

  private boolean equalTo(int synthetic, Features another) {
    return bindable.equals(another.bindable)
        && planUpdateable.equals(another.planUpdateable);
  }

  /**
   * Computes a hash code from attributes: {@code bindable}, {@code planUpdateable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + bindable.hashCode();
    h += (h << 5) + planUpdateable.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Features} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Features{"
        + "bindable=" + bindable
        + ", planUpdateable=" + planUpdateable
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Features", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceplans._Features {
    Boolean bindable;
    Boolean planUpdateable;
    @JsonProperty("bindable")
    public void setBindable(Boolean bindable) {
      this.bindable = bindable;
    }
    @JsonProperty("plan_updateable")
    public void setPlanUpdateable(Boolean planUpdateable) {
      this.planUpdateable = planUpdateable;
    }
    @Override
    public Boolean getBindable() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPlanUpdateable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Features fromJson(Json json) {
    Features.Builder builder = Features.builder();
    if (json.bindable != null) {
      builder.bindable(json.bindable);
    }
    if (json.planUpdateable != null) {
      builder.planUpdateable(json.planUpdateable);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Features Features}.
   * <pre>
   * Features.builder()
   *    .bindable(Boolean) // required {@link Features#getBindable() bindable}
   *    .planUpdateable(Boolean) // required {@link Features#getPlanUpdateable() planUpdateable}
   *    .build();
   * </pre>
   * @return A new Features builder
   */
  public static Features.Builder builder() {
    return new Features.Builder();
  }

  /**
   * Builds instances of type {@link Features Features}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Features", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BINDABLE = 0x1L;
    private static final long INIT_BIT_PLAN_UPDATEABLE = 0x2L;
    private long initBits = 0x3L;

    private Boolean bindable;
    private Boolean planUpdateable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Features} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Features instance) {
      return from((_Features) instance);
    }

    /**
     * Copy abstract value type {@code _Features} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Features instance) {
      Objects.requireNonNull(instance, "instance");
      bindable(instance.getBindable());
      planUpdateable(instance.getPlanUpdateable());
      return this;
    }

    /**
     * Initializes the value for the {@link Features#getBindable() bindable} attribute.
     * @param bindable The value for bindable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("bindable")
    public final Builder bindable(Boolean bindable) {
      this.bindable = Objects.requireNonNull(bindable, "bindable");
      initBits &= ~INIT_BIT_BINDABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Features#getPlanUpdateable() planUpdateable} attribute.
     * @param planUpdateable The value for planUpdateable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("plan_updateable")
    public final Builder planUpdateable(Boolean planUpdateable) {
      this.planUpdateable = Objects.requireNonNull(planUpdateable, "planUpdateable");
      initBits &= ~INIT_BIT_PLAN_UPDATEABLE;
      return this;
    }

    /**
     * Builds a new {@link Features Features}.
     * @return An immutable instance of Features
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Features build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Features(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BINDABLE) != 0) attributes.add("bindable");
      if ((initBits & INIT_BIT_PLAN_UPDATEABLE) != 0) attributes.add("planUpdateable");
      return "Cannot build Features, some of required attributes are not set " + attributes;
    }
  }
}
