package org.cloudfoundry.client.v3.serviceplans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Service Plans operation
 */
@Generated(from = "_ListServicePlansRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServicePlansRequest
    extends org.cloudfoundry.client.v3.serviceplans._ListServicePlansRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final @Nullable Boolean available;
  private final @Nullable List<String> brokerCatalogIds;
  private final @Nullable List<String> labelSelector;
  private final @Nullable List<String> names;
  private final @Nullable List<String> organizationIds;
  private final @Nullable List<String> serviceBrokerIds;
  private final @Nullable List<String> serviceBrokerNames;
  private final @Nullable List<String> serviceInstanceIds;
  private final @Nullable List<String> serviceOfferingIds;
  private final @Nullable List<String> serviceOfferingNames;
  private final @Nullable List<String> spaceIds;

  private ListServicePlansRequest(ListServicePlansRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.available = builder.available;
    this.brokerCatalogIds = builder.brokerCatalogIds == null ? null : createUnmodifiableList(true, builder.brokerCatalogIds);
    this.labelSelector = builder.labelSelector == null ? null : createUnmodifiableList(true, builder.labelSelector);
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.serviceBrokerIds = builder.serviceBrokerIds == null ? null : createUnmodifiableList(true, builder.serviceBrokerIds);
    this.serviceBrokerNames = builder.serviceBrokerNames == null ? null : createUnmodifiableList(true, builder.serviceBrokerNames);
    this.serviceInstanceIds = builder.serviceInstanceIds == null ? null : createUnmodifiableList(true, builder.serviceInstanceIds);
    this.serviceOfferingIds = builder.serviceOfferingIds == null ? null : createUnmodifiableList(true, builder.serviceOfferingIds);
    this.serviceOfferingNames = builder.serviceOfferingNames == null ? null : createUnmodifiableList(true, builder.serviceOfferingNames);
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * Whether the service plan is available
   */
  @Override
  public @Nullable Boolean getAvailable() {
    return available;
  }

  /**
   * List of IDs provided by the service broker for the service plan to filter by
   */
  @Override
  public @Nullable List<String> getBrokerCatalogIds() {
    return brokerCatalogIds;
  }

  /**
   * List of label selectors
   */
  @Override
  public @Nullable List<String> getLabelSelector() {
    return labelSelector;
  }

  /**
   * List of names to filter by
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * List of organization ids to filter by
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * List of service broker ids to filter by
   */
  @Override
  public @Nullable List<String> getServiceBrokerIds() {
    return serviceBrokerIds;
  }

  /**
   * List of service broker names to filter by
   */
  @Override
  public @Nullable List<String> getServiceBrokerNames() {
    return serviceBrokerNames;
  }

  /**
   * List of service instance ids to filter by
   */
  @Override
  public @Nullable List<String> getServiceInstanceIds() {
    return serviceInstanceIds;
  }

  /**
   * List of service offering ids to filter by
   */
  @Override
  public @Nullable List<String> getServiceOfferingIds() {
    return serviceOfferingIds;
  }

  /**
   * List of service offering names to filter by
   */
  @Override
  public @Nullable List<String> getServiceOfferingNames() {
    return serviceOfferingNames;
  }

  /**
   * List of space ids to filter by
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * This instance is equal to all instances of {@code ListServicePlansRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServicePlansRequest
        && equalTo(0, (ListServicePlansRequest) another);
  }

  private boolean equalTo(int synthetic, ListServicePlansRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && Objects.equals(available, another.available)
        && Objects.equals(brokerCatalogIds, another.brokerCatalogIds)
        && Objects.equals(labelSelector, another.labelSelector)
        && Objects.equals(names, another.names)
        && Objects.equals(organizationIds, another.organizationIds)
        && Objects.equals(serviceBrokerIds, another.serviceBrokerIds)
        && Objects.equals(serviceBrokerNames, another.serviceBrokerNames)
        && Objects.equals(serviceInstanceIds, another.serviceInstanceIds)
        && Objects.equals(serviceOfferingIds, another.serviceOfferingIds)
        && Objects.equals(serviceOfferingNames, another.serviceOfferingNames)
        && Objects.equals(spaceIds, another.spaceIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code available}, {@code brokerCatalogIds}, {@code labelSelector}, {@code names}, {@code organizationIds}, {@code serviceBrokerIds}, {@code serviceBrokerNames}, {@code serviceInstanceIds}, {@code serviceOfferingIds}, {@code serviceOfferingNames}, {@code spaceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + Objects.hashCode(available);
    h += (h << 5) + Objects.hashCode(brokerCatalogIds);
    h += (h << 5) + Objects.hashCode(labelSelector);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + Objects.hashCode(serviceBrokerIds);
    h += (h << 5) + Objects.hashCode(serviceBrokerNames);
    h += (h << 5) + Objects.hashCode(serviceInstanceIds);
    h += (h << 5) + Objects.hashCode(serviceOfferingIds);
    h += (h << 5) + Objects.hashCode(serviceOfferingNames);
    h += (h << 5) + Objects.hashCode(spaceIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServicePlansRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServicePlansRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", available=" + available
        + ", brokerCatalogIds=" + brokerCatalogIds
        + ", labelSelector=" + labelSelector
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", serviceBrokerIds=" + serviceBrokerIds
        + ", serviceBrokerNames=" + serviceBrokerNames
        + ", serviceInstanceIds=" + serviceInstanceIds
        + ", serviceOfferingIds=" + serviceOfferingIds
        + ", serviceOfferingNames=" + serviceOfferingNames
        + ", spaceIds=" + spaceIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListServicePlansRequest ListServicePlansRequest}.
   * <pre>
   * ListServicePlansRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListServicePlansRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListServicePlansRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListServicePlansRequest#getPerPage() perPage}
   *    .available(Boolean | null) // nullable {@link ListServicePlansRequest#getAvailable() available}
   *    .brokerCatalogIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getBrokerCatalogIds() brokerCatalogIds}
   *    .labelSelector(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getLabelSelector() labelSelector}
   *    .names(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getNames() names}
   *    .organizationIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getOrganizationIds() organizationIds}
   *    .serviceBrokerIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds}
   *    .serviceBrokerNames(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getServiceBrokerNames() serviceBrokerNames}
   *    .serviceInstanceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds}
   *    .serviceOfferingIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getServiceOfferingIds() serviceOfferingIds}
   *    .serviceOfferingNames(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getServiceOfferingNames() serviceOfferingNames}
   *    .spaceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlansRequest#getSpaceIds() spaceIds}
   *    .build();
   * </pre>
   * @return A new ListServicePlansRequest builder
   */
  public static ListServicePlansRequest.Builder builder() {
    return new ListServicePlansRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServicePlansRequest ListServicePlansRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServicePlansRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private Boolean available;
    private List<String> brokerCatalogIds = null;
    private List<String> labelSelector = null;
    private List<String> names = null;
    private List<String> organizationIds = null;
    private List<String> serviceBrokerIds = null;
    private List<String> serviceBrokerNames = null;
    private List<String> serviceInstanceIds = null;
    private List<String> serviceOfferingIds = null;
    private List<String> serviceOfferingNames = null;
    private List<String> spaceIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServicePlansRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServicePlansRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServicePlansRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServicePlansRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.client.v3.serviceplans._ListServicePlansRequest) {
        org.cloudfoundry.client.v3.serviceplans._ListServicePlansRequest instance = (org.cloudfoundry.client.v3.serviceplans._ListServicePlansRequest) object;
        List<String> brokerCatalogIdsValue = instance.getBrokerCatalogIds();
        if (brokerCatalogIdsValue != null) {
          addAllBrokerCatalogIds(brokerCatalogIdsValue);
        }
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        List<String> serviceBrokerNamesValue = instance.getServiceBrokerNames();
        if (serviceBrokerNamesValue != null) {
          addAllServiceBrokerNames(serviceBrokerNamesValue);
        }
        List<String> serviceInstanceIdsValue = instance.getServiceInstanceIds();
        if (serviceInstanceIdsValue != null) {
          addAllServiceInstanceIds(serviceInstanceIdsValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
        List<String> serviceOfferingNamesValue = instance.getServiceOfferingNames();
        if (serviceOfferingNamesValue != null) {
          addAllServiceOfferingNames(serviceOfferingNamesValue);
        }
        Boolean availableValue = instance.getAvailable();
        if (availableValue != null) {
          available(availableValue);
        }
        List<String> labelSelectorValue = instance.getLabelSelector();
        if (labelSelectorValue != null) {
          addAllLabelSelector(labelSelectorValue);
        }
        List<String> serviceBrokerIdsValue = instance.getServiceBrokerIds();
        if (serviceBrokerIdsValue != null) {
          addAllServiceBrokerIds(serviceBrokerIdsValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
        List<String> serviceOfferingIdsValue = instance.getServiceOfferingIds();
        if (serviceOfferingIdsValue != null) {
          addAllServiceOfferingIds(serviceOfferingIdsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListServicePlansRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlansRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlansRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlansRequest#getAvailable() available} attribute.
     * @param available The value for available (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder available(@Nullable Boolean available) {
      this.available = available;
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getBrokerCatalogIds() brokerCatalogIds} list.
     * @param element A brokerCatalogIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder brokerCatalogId(String element) {
      if (this.brokerCatalogIds == null) {
        this.brokerCatalogIds = new ArrayList<String>();
      }
      this.brokerCatalogIds.add(Objects.requireNonNull(element, "brokerCatalogIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getBrokerCatalogIds() brokerCatalogIds} list.
     * @param elements An array of brokerCatalogIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder brokerCatalogIds(String... elements) {
      if (this.brokerCatalogIds == null) {
        this.brokerCatalogIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.brokerCatalogIds.add(Objects.requireNonNull(element, "brokerCatalogIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getBrokerCatalogIds() brokerCatalogIds} list.
     * @param elements An iterable of brokerCatalogIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder brokerCatalogIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.brokerCatalogIds = null;
        return this;
      }
      this.brokerCatalogIds = new ArrayList<String>();
      return addAllBrokerCatalogIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getBrokerCatalogIds() brokerCatalogIds} list.
     * @param elements An iterable of brokerCatalogIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBrokerCatalogIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "brokerCatalogIds element");
      if (this.brokerCatalogIds == null) {
        this.brokerCatalogIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.brokerCatalogIds.add(Objects.requireNonNull(element, "brokerCatalogIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getLabelSelector() labelSelector} list.
     * @param element A labelSelector element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(String element) {
      if (this.labelSelector == null) {
        this.labelSelector = new ArrayList<String>();
      }
      this.labelSelector.add(Objects.requireNonNull(element, "labelSelector element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getLabelSelector() labelSelector} list.
     * @param elements An array of labelSelector elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(String... elements) {
      if (this.labelSelector == null) {
        this.labelSelector = new ArrayList<String>();
      }
      for (String element : elements) {
        this.labelSelector.add(Objects.requireNonNull(element, "labelSelector element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getLabelSelector() labelSelector} list.
     * @param elements An iterable of labelSelector elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.labelSelector = null;
        return this;
      }
      this.labelSelector = new ArrayList<String>();
      return addAllLabelSelector(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getLabelSelector() labelSelector} list.
     * @param elements An iterable of labelSelector elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLabelSelector(Iterable<String> elements) {
      Objects.requireNonNull(elements, "labelSelector element");
      if (this.labelSelector == null) {
        this.labelSelector = new ArrayList<String>();
      }
      for (String element : elements) {
        this.labelSelector.add(Objects.requireNonNull(element, "labelSelector element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param element A serviceBrokerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String element) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An array of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(String... elements) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBrokerIds = null;
        return this;
      }
      this.serviceBrokerIds = new ArrayList<String>();
      return addAllServiceBrokerIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBrokerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBrokerIds element");
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getServiceBrokerNames() serviceBrokerNames} list.
     * @param element A serviceBrokerNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerName(String element) {
      if (this.serviceBrokerNames == null) {
        this.serviceBrokerNames = new ArrayList<String>();
      }
      this.serviceBrokerNames.add(Objects.requireNonNull(element, "serviceBrokerNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceBrokerNames() serviceBrokerNames} list.
     * @param elements An array of serviceBrokerNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerNames(String... elements) {
      if (this.serviceBrokerNames == null) {
        this.serviceBrokerNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerNames.add(Objects.requireNonNull(element, "serviceBrokerNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getServiceBrokerNames() serviceBrokerNames} list.
     * @param elements An iterable of serviceBrokerNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerNames(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBrokerNames = null;
        return this;
      }
      this.serviceBrokerNames = new ArrayList<String>();
      return addAllServiceBrokerNames(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceBrokerNames() serviceBrokerNames} list.
     * @param elements An iterable of serviceBrokerNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBrokerNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBrokerNames element");
      if (this.serviceBrokerNames == null) {
        this.serviceBrokerNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerNames.add(Objects.requireNonNull(element, "serviceBrokerNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param element A serviceInstanceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String element) {
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An array of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(String... elements) {
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceInstanceIds = null;
        return this;
      }
      this.serviceInstanceIds = new ArrayList<String>();
      return addAllServiceInstanceIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceInstanceIds element");
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getServiceOfferingIds() serviceOfferingIds} list.
     * @param element A serviceOfferingIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingId(String element) {
      if (this.serviceOfferingIds == null) {
        this.serviceOfferingIds = new ArrayList<String>();
      }
      this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceOfferingIds() serviceOfferingIds} list.
     * @param elements An array of serviceOfferingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingIds(String... elements) {
      if (this.serviceOfferingIds == null) {
        this.serviceOfferingIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getServiceOfferingIds() serviceOfferingIds} list.
     * @param elements An iterable of serviceOfferingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceOfferingIds = null;
        return this;
      }
      this.serviceOfferingIds = new ArrayList<String>();
      return addAllServiceOfferingIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceOfferingIds() serviceOfferingIds} list.
     * @param elements An iterable of serviceOfferingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceOfferingIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceOfferingIds element");
      if (this.serviceOfferingIds == null) {
        this.serviceOfferingIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getServiceOfferingNames() serviceOfferingNames} list.
     * @param element A serviceOfferingNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingName(String element) {
      if (this.serviceOfferingNames == null) {
        this.serviceOfferingNames = new ArrayList<String>();
      }
      this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceOfferingNames() serviceOfferingNames} list.
     * @param elements An array of serviceOfferingNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingNames(String... elements) {
      if (this.serviceOfferingNames == null) {
        this.serviceOfferingNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getServiceOfferingNames() serviceOfferingNames} list.
     * @param elements An iterable of serviceOfferingNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingNames(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceOfferingNames = null;
        return this;
      }
      this.serviceOfferingNames = new ArrayList<String>();
      return addAllServiceOfferingNames(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceOfferingNames() serviceOfferingNames} list.
     * @param elements An iterable of serviceOfferingNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceOfferingNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceOfferingNames element");
      if (this.serviceOfferingNames == null) {
        this.serviceOfferingNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListServicePlansRequest ListServicePlansRequest}.
     * @return An immutable instance of ListServicePlansRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServicePlansRequest build() {
      return new ListServicePlansRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
