package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity representing a service plan schema
 */
@Generated(from = "_Schema", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Schema extends org.cloudfoundry.client.v3.serviceplans._Schema {
  private final @Nullable Parameters parameters;

  private Schema(Schema.Builder builder) {
    this.parameters = builder.parameters;
  }

  /**
   * The schema parameters
   */
  @JsonProperty("parameters")
  @Override
  public @Nullable Parameters getParameters() {
    return parameters;
  }

  /**
   * This instance is equal to all instances of {@code Schema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Schema
        && equalTo(0, (Schema) another);
  }

  private boolean equalTo(int synthetic, Schema another) {
    return Objects.equals(parameters, another.parameters);
  }

  /**
   * Computes a hash code from attributes: {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(parameters);
    return h;
  }

  /**
   * Prints the immutable value {@code Schema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Schema{"
        + "parameters=" + parameters
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Schema", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceplans._Schema {
    Parameters parameters;
    @JsonProperty("parameters")
    public void setParameters(@Nullable Parameters parameters) {
      this.parameters = parameters;
    }
    @Override
    public Parameters getParameters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Schema fromJson(Json json) {
    Schema.Builder builder = Schema.builder();
    if (json.parameters != null) {
      builder.parameters(json.parameters);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Schema Schema}.
   * <pre>
   * Schema.builder()
   *    .parameters(org.cloudfoundry.client.v3.serviceplans.Parameters | null) // nullable {@link Schema#getParameters() parameters}
   *    .build();
   * </pre>
   * @return A new Schema builder
   */
  public static Schema.Builder builder() {
    return new Schema.Builder();
  }

  /**
   * Builds instances of type {@link Schema Schema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Schema", generator = "Immutables")
  public static final class Builder {
    private Parameters parameters;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Schema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Schema instance) {
      return from((_Schema) instance);
    }

    /**
     * Copy abstract value type {@code _Schema} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Schema instance) {
      Objects.requireNonNull(instance, "instance");
      Parameters parametersValue = instance.getParameters();
      if (parametersValue != null) {
        parameters(parametersValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#getParameters() parameters} attribute.
     * @param parameters The value for parameters (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parameters")
    public final Builder parameters(@Nullable Parameters parameters) {
      this.parameters = parameters;
      return this;
    }

    /**
     * Builds a new {@link Schema Schema}.
     * @return An immutable instance of Schema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Schema build() {
      return new Schema(this);
    }
  }
}
