package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Update Service Plan operation
 */
@Generated(from = "_UpdateServicePlanResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServicePlanResponse
    extends org.cloudfoundry.client.v3.serviceplans._UpdateServicePlanResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final Boolean available;
  private final BrokerCatalog brokerCatalog;
  private final List<Cost> costs;
  private final String description;
  private final Boolean free;
  private final @Nullable MaintenanceInfo maintenanceInfo;
  private final @Nullable Metadata metadata;
  private final String name;
  private final ServicePlanRelationships relationships;
  private final Schemas schemas;
  private final Visibility visibilityType;

  private UpdateServicePlanResponse(UpdateServicePlanResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.available = builder.available;
    this.brokerCatalog = builder.brokerCatalog;
    this.costs = createUnmodifiableList(true, builder.costs);
    this.description = builder.description;
    this.free = builder.free;
    this.maintenanceInfo = builder.maintenanceInfo;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.relationships = builder.relationships;
    this.schemas = builder.schemas;
    this.visibilityType = builder.visibilityType;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * Whether or not the service plan is available
   */
  @JsonProperty("available")
  @Override
  public Boolean getAvailable() {
    return available;
  }

  /**
   * Information obtained from the service broker catalog
   */
  @JsonProperty("broker_catalog")
  @Override
  public BrokerCatalog getBrokerCatalog() {
    return brokerCatalog;
  }

  /**
   * The cost of the service plan as obtained from the service broker catalog
   */
  @JsonProperty("costs")
  @Override
  public List<Cost> getCosts() {
    return costs;
  }

  /**
   * Description of the service plan
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * Whether or not the service plan is free of charge
   */
  @JsonProperty("free")
  @Override
  public Boolean getFree() {
    return free;
  }

  /**
   * Information about the version of this service plan
   */
  @JsonProperty("maintenance_info")
  @Override
  public @Nullable MaintenanceInfo getMaintenanceInfo() {
    return maintenanceInfo;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name of the service plan
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public ServicePlanRelationships getRelationships() {
    return relationships;
  }

  /**
   * Schema definitions for service instances and service bindings for the service plan
   */
  @JsonProperty("schemas")
  @Override
  public Schemas getSchemas() {
    return schemas;
  }

  /**
   * Denotes the visibility of the plan
   */
  @JsonProperty("visibility_type")
  @Override
  public Visibility getVisibilityType() {
    return visibilityType;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServicePlanResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServicePlanResponse
        && equalTo(0, (UpdateServicePlanResponse) another);
  }

  private boolean equalTo(int synthetic, UpdateServicePlanResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && available.equals(another.available)
        && brokerCatalog.equals(another.brokerCatalog)
        && costs.equals(another.costs)
        && description.equals(another.description)
        && free.equals(another.free)
        && Objects.equals(maintenanceInfo, another.maintenanceInfo)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && relationships.equals(another.relationships)
        && schemas.equals(another.schemas)
        && visibilityType.equals(another.visibilityType);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code available}, {@code brokerCatalog}, {@code costs}, {@code description}, {@code free}, {@code maintenanceInfo}, {@code metadata}, {@code name}, {@code relationships}, {@code schemas}, {@code visibilityType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + available.hashCode();
    h += (h << 5) + brokerCatalog.hashCode();
    h += (h << 5) + costs.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + free.hashCode();
    h += (h << 5) + Objects.hashCode(maintenanceInfo);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + schemas.hashCode();
    h += (h << 5) + visibilityType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServicePlanResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServicePlanResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", available=" + available
        + ", brokerCatalog=" + brokerCatalog
        + ", costs=" + costs
        + ", description=" + description
        + ", free=" + free
        + ", maintenanceInfo=" + maintenanceInfo
        + ", metadata=" + metadata
        + ", name=" + name
        + ", relationships=" + relationships
        + ", schemas=" + schemas
        + ", visibilityType=" + visibilityType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServicePlanResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceplans._UpdateServicePlanResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    Boolean available;
    BrokerCatalog brokerCatalog;
    List<Cost> costs = Collections.emptyList();
    String description;
    Boolean free;
    MaintenanceInfo maintenanceInfo;
    Metadata metadata;
    String name;
    ServicePlanRelationships relationships;
    Schemas schemas;
    Visibility visibilityType;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("available")
    public void setAvailable(Boolean available) {
      this.available = available;
    }
    @JsonProperty("broker_catalog")
    public void setBrokerCatalog(BrokerCatalog brokerCatalog) {
      this.brokerCatalog = brokerCatalog;
    }
    @JsonProperty("costs")
    public void setCosts(List<Cost> costs) {
      this.costs = costs;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("free")
    public void setFree(Boolean free) {
      this.free = free;
    }
    @JsonProperty("maintenance_info")
    public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(ServicePlanRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("schemas")
    public void setSchemas(Schemas schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("visibility_type")
    public void setVisibilityType(Visibility visibilityType) {
      this.visibilityType = visibilityType;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAvailable() { throw new UnsupportedOperationException(); }
    @Override
    public BrokerCatalog getBrokerCatalog() { throw new UnsupportedOperationException(); }
    @Override
    public List<Cost> getCosts() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getFree() { throw new UnsupportedOperationException(); }
    @Override
    public MaintenanceInfo getMaintenanceInfo() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ServicePlanRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public Schemas getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public Visibility getVisibilityType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServicePlanResponse fromJson(Json json) {
    UpdateServicePlanResponse.Builder builder = UpdateServicePlanResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.available != null) {
      builder.available(json.available);
    }
    if (json.brokerCatalog != null) {
      builder.brokerCatalog(json.brokerCatalog);
    }
    if (json.costs != null) {
      builder.addAllCosts(json.costs);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.free != null) {
      builder.free(json.free);
    }
    if (json.maintenanceInfo != null) {
      builder.maintenanceInfo(json.maintenanceInfo);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.schemas != null) {
      builder.schemas(json.schemas);
    }
    if (json.visibilityType != null) {
      builder.visibilityType(json.visibilityType);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServicePlanResponse UpdateServicePlanResponse}.
   * <pre>
   * UpdateServicePlanResponse.builder()
   *    .createdAt(String) // required {@link UpdateServicePlanResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link UpdateServicePlanResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link UpdateServicePlanResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link UpdateServicePlanResponse#getUpdatedAt() updatedAt}
   *    .available(Boolean) // required {@link UpdateServicePlanResponse#getAvailable() available}
   *    .brokerCatalog(org.cloudfoundry.client.v3.serviceplans.BrokerCatalog) // required {@link UpdateServicePlanResponse#getBrokerCatalog() brokerCatalog}
   *    .cost|addAllCosts(Cost) // {@link UpdateServicePlanResponse#getCosts() costs} elements
   *    .description(String) // required {@link UpdateServicePlanResponse#getDescription() description}
   *    .free(Boolean) // required {@link UpdateServicePlanResponse#getFree() free}
   *    .maintenanceInfo(org.cloudfoundry.client.v3.serviceplans.MaintenanceInfo | null) // nullable {@link UpdateServicePlanResponse#getMaintenanceInfo() maintenanceInfo}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateServicePlanResponse#getMetadata() metadata}
   *    .name(String) // required {@link UpdateServicePlanResponse#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.serviceplans.ServicePlanRelationships) // required {@link UpdateServicePlanResponse#getRelationships() relationships}
   *    .schemas(org.cloudfoundry.client.v3.serviceplans.Schemas) // required {@link UpdateServicePlanResponse#getSchemas() schemas}
   *    .visibilityType(org.cloudfoundry.client.v3.serviceplans.Visibility) // required {@link UpdateServicePlanResponse#getVisibilityType() visibilityType}
   *    .build();
   * </pre>
   * @return A new UpdateServicePlanResponse builder
   */
  public static UpdateServicePlanResponse.Builder builder() {
    return new UpdateServicePlanResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServicePlanResponse UpdateServicePlanResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServicePlanResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_AVAILABLE = 0x4L;
    private static final long INIT_BIT_BROKER_CATALOG = 0x8L;
    private static final long INIT_BIT_DESCRIPTION = 0x10L;
    private static final long INIT_BIT_FREE = 0x20L;
    private static final long INIT_BIT_NAME = 0x40L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x80L;
    private static final long INIT_BIT_SCHEMAS = 0x100L;
    private static final long INIT_BIT_VISIBILITY_TYPE = 0x200L;
    private long initBits = 0x3ffL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private Boolean available;
    private BrokerCatalog brokerCatalog;
    private List<Cost> costs = new ArrayList<Cost>();
    private String description;
    private Boolean free;
    private MaintenanceInfo maintenanceInfo;
    private Metadata metadata;
    private String name;
    private ServicePlanRelationships relationships;
    private Schemas schemas;
    private Visibility visibilityType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.serviceplans.ServicePlan} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServicePlan instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServicePlanResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServicePlanResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateServicePlanResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateServicePlanResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x20L) == 0) {
          createdAt(instance.getCreatedAt());
          bits |= 0x20L;
        }
        if ((bits & 0x200L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          id(instance.getId());
          bits |= 0x400L;
        }
        if ((bits & 0x4000L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4000L;
        }
      }
      if (object instanceof ServicePlan) {
        ServicePlan instance = (ServicePlan) object;
        if ((bits & 0x1L) == 0) {
          addAllCosts(instance.getCosts());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          available(instance.getAvailable());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          description(instance.getDescription());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
          if (maintenanceInfoValue != null) {
            maintenanceInfo(maintenanceInfoValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          createdAt(instance.getCreatedAt());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          relationships(instance.getRelationships());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          schemas(instance.getSchemas());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          name(instance.getName());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          id(instance.getId());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          free(instance.getFree());
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          brokerCatalog(instance.getBrokerCatalog());
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          visibilityType(instance.getVisibilityType());
          bits |= 0x2000L;
        }
        if ((bits & 0x4000L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4000L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.serviceplans._UpdateServicePlanResponse) {
        org.cloudfoundry.client.v3.serviceplans._UpdateServicePlanResponse instance = (org.cloudfoundry.client.v3.serviceplans._UpdateServicePlanResponse) object;
        if ((bits & 0x1L) == 0) {
          addAllCosts(instance.getCosts());
          bits |= 0x1L;
        }
        if ((bits & 0x40L) == 0) {
          relationships(instance.getRelationships());
          bits |= 0x40L;
        }
        if ((bits & 0x2L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x80L) == 0) {
          schemas(instance.getSchemas());
          bits |= 0x80L;
        }
        if ((bits & 0x4L) == 0) {
          available(instance.getAvailable());
          bits |= 0x4L;
        }
        if ((bits & 0x100L) == 0) {
          name(instance.getName());
          bits |= 0x100L;
        }
        if ((bits & 0x8L) == 0) {
          description(instance.getDescription());
          bits |= 0x8L;
        }
        if ((bits & 0x800L) == 0) {
          free(instance.getFree());
          bits |= 0x800L;
        }
        if ((bits & 0x10L) == 0) {
          MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
          if (maintenanceInfoValue != null) {
            maintenanceInfo(maintenanceInfoValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x1000L) == 0) {
          brokerCatalog(instance.getBrokerCatalog());
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          visibilityType(instance.getVisibilityType());
          bits |= 0x2000L;
        }
      }
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link UpdateServicePlanResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateServicePlanResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateServicePlanResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateServicePlanResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getAvailable() available} attribute.
     * @param available The value for available 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("available")
    public final Builder available(Boolean available) {
      this.available = Objects.requireNonNull(available, "available");
      initBits &= ~INIT_BIT_AVAILABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getBrokerCatalog() brokerCatalog} attribute.
     * @param brokerCatalog The value for brokerCatalog 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("broker_catalog")
    public final Builder brokerCatalog(BrokerCatalog brokerCatalog) {
      this.brokerCatalog = Objects.requireNonNull(brokerCatalog, "brokerCatalog");
      initBits &= ~INIT_BIT_BROKER_CATALOG;
      return this;
    }

    /**
     * Adds one element to {@link UpdateServicePlanResponse#getCosts() costs} list.
     * @param element A costs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cost(Cost element) {
      this.costs.add(Objects.requireNonNull(element, "costs element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateServicePlanResponse#getCosts() costs} list.
     * @param elements An array of costs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder costs(Cost... elements) {
      for (Cost element : elements) {
        this.costs.add(Objects.requireNonNull(element, "costs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateServicePlanResponse#getCosts() costs} list.
     * @param elements An iterable of costs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("costs")
    public final Builder costs(Iterable<? extends Cost> elements) {
      this.costs.clear();
      return addAllCosts(elements);
    }

    /**
     * Adds elements to {@link UpdateServicePlanResponse#getCosts() costs} list.
     * @param elements An iterable of costs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCosts(Iterable<? extends Cost> elements) {
      for (Cost element : elements) {
        this.costs.add(Objects.requireNonNull(element, "costs element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getFree() free} attribute.
     * @param free The value for free 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("free")
    public final Builder free(Boolean free) {
      this.free = Objects.requireNonNull(free, "free");
      initBits &= ~INIT_BIT_FREE;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getMaintenanceInfo() maintenanceInfo} attribute.
     * @param maintenanceInfo The value for maintenanceInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maintenance_info")
    public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(ServicePlanRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getSchemas() schemas} attribute.
     * @param schemas The value for schemas 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Schemas schemas) {
      this.schemas = Objects.requireNonNull(schemas, "schemas");
      initBits &= ~INIT_BIT_SCHEMAS;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanResponse#getVisibilityType() visibilityType} attribute.
     * @param visibilityType The value for visibilityType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("visibility_type")
    public final Builder visibilityType(Visibility visibilityType) {
      this.visibilityType = Objects.requireNonNull(visibilityType, "visibilityType");
      initBits &= ~INIT_BIT_VISIBILITY_TYPE;
      return this;
    }

    /**
     * Builds a new {@link UpdateServicePlanResponse UpdateServicePlanResponse}.
     * @return An immutable instance of UpdateServicePlanResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServicePlanResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServicePlanResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_AVAILABLE) != 0) attributes.add("available");
      if ((initBits & INIT_BIT_BROKER_CATALOG) != 0) attributes.add("brokerCatalog");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_FREE) != 0) attributes.add("free");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_SCHEMAS) != 0) attributes.add("schemas");
      if ((initBits & INIT_BIT_VISIBILITY_TYPE) != 0) attributes.add("visibilityType");
      return "Cannot build UpdateServicePlanResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
